/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.peptide_fragmentation;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.identification.peptide_fragmentation.PeptideFragmentationModel;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.SequestFragmentationModel;
import com.compomics.util.experiment.identification.peptide_fragmentation.models.UniformFragmentation;

public class FragmentItensityPredictor {
    private final PeptideFragmentationModel peptideFragmentationModel;

    public FragmentItensityPredictor() {
        this.peptideFragmentationModel = null;
    }

    public FragmentItensityPredictor(PeptideFragmentationModel peptideFragmentationModel) {
        this.peptideFragmentationModel = peptideFragmentationModel;
    }

    public Double getIntentisy(Ion ion) {
        switch (this.peptideFragmentationModel) {
            case uniform: {
                return UniformFragmentation.getIntensity();
            }
            case sequest: {
                return SequestFragmentationModel.getIntensity(ion);
            }
        }
        throw new UnsupportedOperationException("Fragmentation model " + (Object)((Object)this.peptideFragmentationModel) + " not supported.");
    }
}

