/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.peptide_shaker;

import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ModificationScoring
extends ExperimentObject {
    static final long serialVersionUID = -3357368272501542941L;
    public static final int NOT_FOUND = -1;
    public static final int RANDOM = 0;
    public static final int DOUBTFUL = 1;
    public static final int CONFIDENT = 2;
    public static final int VERY_CONFIDENT = 3;
    private HashMap<Integer, Double> deltaScoresAtAA;
    private HashMap<Integer, Double> probabilisticScoresAtAA;
    private String ptmName;
    public static final String SEPARATOR = "|";
    private HashMap<Integer, Integer> ptmLocationAtAA;

    public ModificationScoring() {
    }

    public ModificationScoring(String ptmName) {
        this.ptmName = ptmName;
    }

    public String getName() {
        return this.ptmName;
    }

    public Set<Integer> getScoredSites() {
        Set<Integer> dSites = this.getDSites();
        Set<Integer> pSites = this.getProbabilisticSites();
        HashSet<Integer> result = new HashSet<Integer>(dSites.size() + pSites.size());
        result.addAll(dSites);
        result.addAll(pSites);
        return result;
    }

    public void setDeltaScore(int site, double score) {
        if (this.deltaScoresAtAA == null) {
            this.deltaScoresAtAA = new HashMap(1);
        }
        this.deltaScoresAtAA.put(site, score);
    }

    public double getDeltaScore(int site) {
        if (this.deltaScoresAtAA == null) {
            return 0.0;
        }
        Double score = this.deltaScoresAtAA.get(site);
        if (score == null) {
            return 0.0;
        }
        return score;
    }

    public void setProbabilisticScore(int site, double score) {
        if (this.probabilisticScoresAtAA == null) {
            this.probabilisticScoresAtAA = new HashMap(1);
        }
        this.probabilisticScoresAtAA.put(site, score);
    }

    public double getProbabilisticScore(int site) {
        if (this.probabilisticScoresAtAA == null) {
            return 0.0;
        }
        Double score = this.probabilisticScoresAtAA.get(site);
        if (score == null) {
            return 0.0;
        }
        return score;
    }

    public Set<Integer> getProbabilisticSites() {
        if (this.probabilisticScoresAtAA == null) {
            return new HashSet<Integer>(0);
        }
        return this.probabilisticScoresAtAA.keySet();
    }

    public ArrayList<Integer> getOrderedProbabilisticSites() {
        HashMap<Double, ArrayList<Integer>> siteMap = new HashMap<Double, ArrayList<Integer>>(1);
        if (this.probabilisticScoresAtAA != null) {
            for (int site : this.probabilisticScoresAtAA.keySet()) {
                double score = this.probabilisticScoresAtAA.get(site);
                ArrayList<Integer> sitesAtAA = (ArrayList<Integer>)siteMap.get(score);
                if (sitesAtAA == null) {
                    sitesAtAA = new ArrayList<Integer>();
                    siteMap.put(score, sitesAtAA);
                }
                sitesAtAA.add(site);
            }
        }
        ArrayList scores = new ArrayList(siteMap.keySet());
        Collections.sort(scores, Collections.reverseOrder());
        ArrayList<Integer> result = new ArrayList<Integer>();
        Iterator iterator = scores.iterator();
        while (iterator.hasNext()) {
            double score = (Double)iterator.next();
            ArrayList sites = (ArrayList)siteMap.get(score);
            if (sites.size() > 2) {
                Collections.shuffle(sites);
            }
            result.addAll(sites);
        }
        return result;
    }

    public Set<Integer> getDSites() {
        if (this.deltaScoresAtAA == null) {
            return new HashSet<Integer>(0);
        }
        return this.deltaScoresAtAA.keySet();
    }

    public ArrayList<Integer> getOrderedDSites() {
        HashMap<Double, ArrayList<Integer>> siteMap = new HashMap<Double, ArrayList<Integer>>(1);
        if (this.deltaScoresAtAA != null) {
            for (int site : this.deltaScoresAtAA.keySet()) {
                double score = this.deltaScoresAtAA.get(site);
                ArrayList<Integer> sitesAtAA = (ArrayList<Integer>)siteMap.get(score);
                if (sitesAtAA == null) {
                    sitesAtAA = new ArrayList<Integer>();
                    siteMap.put(score, sitesAtAA);
                }
                sitesAtAA.add(site);
            }
        }
        ArrayList scores = new ArrayList(siteMap.keySet());
        Collections.sort(scores, Collections.reverseOrder());
        ArrayList<Integer> result = new ArrayList<Integer>();
        Iterator iterator = scores.iterator();
        while (iterator.hasNext()) {
            double score = (Double)iterator.next();
            ArrayList sites = (ArrayList)siteMap.get(score);
            if (sites.size() > 2) {
                Collections.shuffle(sites);
            }
            result.addAll(sites);
        }
        return result;
    }

    public void addAll(ModificationScoring anotherScore) {
        double newScore;
        for (int position : anotherScore.getDSites()) {
            newScore = anotherScore.getDeltaScore(position);
            if (!(this.getDeltaScore(position) < newScore)) continue;
            this.setDeltaScore(position, newScore);
        }
        for (int position : anotherScore.getProbabilisticSites()) {
            newScore = anotherScore.getProbabilisticScore(position);
            if (!(this.getProbabilisticScore(position) < newScore)) continue;
            this.setProbabilisticScore(position, newScore);
        }
        HashMap<Integer, Integer> map = anotherScore.getPtmLocationAtAA();
        if (this.ptmLocationAtAA == null) {
            this.ptmLocationAtAA = new HashMap(map.size());
        }
        for (int otherSite : map.keySet()) {
            Integer currentSiteConfidence = this.ptmLocationAtAA.get(otherSite);
            if (currentSiteConfidence == null) {
                this.ptmLocationAtAA.put(otherSite, map.get(otherSite));
                continue;
            }
            this.ptmLocationAtAA.put(otherSite, Math.max(currentSiteConfidence, map.get(otherSite)));
        }
    }

    public void setSiteConfidence(int site, int confidenceLevel) {
        if (this.ptmLocationAtAA == null) {
            this.ptmLocationAtAA = new HashMap(1);
        }
        this.ptmLocationAtAA.put(site, confidenceLevel);
    }

    public HashMap<Integer, Integer> getPtmLocationAtAA() {
        if (this.ptmLocationAtAA == null) {
            return new HashMap<Integer, Integer>(0);
        }
        return this.ptmLocationAtAA;
    }

    public Set<Integer> getAllPtmLocations() {
        if (this.ptmLocationAtAA == null) {
            return new HashSet<Integer>(0);
        }
        return this.ptmLocationAtAA.keySet();
    }

    public ArrayList<Integer> getOrderedPtmLocations() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.getAllPtmLocations());
        Collections.sort(result);
        return result;
    }

    public int getLocalizationConfidence(int site) {
        if (this.ptmLocationAtAA == null) {
            return -1;
        }
        Integer confidence = this.ptmLocationAtAA.get(site);
        if (confidence == null) {
            confidence = -1;
        }
        return confidence;
    }

    public int getMinimalLocalizationConfidence() {
        if (this.ptmLocationAtAA == null || this.ptmLocationAtAA.isEmpty()) {
            return -1;
        }
        int minConfidence = 3;
        for (int confidence : this.ptmLocationAtAA.values()) {
            if (confidence >= minConfidence) continue;
            int n = minConfidence;
        }
        return minConfidence;
    }

    public ArrayList<Integer> getConfidentPtmLocations() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.addAll(this.getPtmLocations(2));
        result.addAll(this.getPtmLocations(3));
        return result;
    }

    public ArrayList<Integer> getSecondaryPtmLocations() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.addAll(this.getPtmLocations(-1));
        result.addAll(this.getPtmLocations(0));
        result.addAll(this.getPtmLocations(1));
        return result;
    }

    public ArrayList<Integer> getPtmLocations(int confidenceLevel) {
        ArrayList<Integer> result = new ArrayList<Integer>(1);
        if (this.ptmLocationAtAA != null) {
            for (int site : this.ptmLocationAtAA.keySet()) {
                if (confidenceLevel != this.ptmLocationAtAA.get(site)) continue;
                result.add(site);
            }
        }
        return result;
    }

    public static String[] getPossibleConfidenceLevels() {
        String[] result = new String[]{"Not Found", "Random", "Doubtful", "Confident", "Very Confident"};
        return result;
    }

    public static String getConfidenceLevel(int index) {
        switch (index) {
            case -1: {
                return "Not Found";
            }
            case 0: {
                return "Random";
            }
            case 1: {
                return "Doubtful";
            }
            case 2: {
                return "Confident";
            }
            case 3: {
                return "Very Confident";
            }
        }
        return "";
    }
}

