/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_sequences.digestion;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.protein_sequences.digestion.ExtendedPeptide;
import com.compomics.util.experiment.identification.protein_sequences.digestion.ProteinIteratorUtils;
import com.compomics.util.general.BoxedObject;
import java.util.Arrays;
import java.util.HashMap;

public class PeptideDraft {
    private char[] sequence;
    private String nTermModification;
    private String cTermModification;
    private HashMap<Integer, String> fixedAaModifications;
    private double mass;
    private int missedCleavages = 0;
    private int nX = 0;
    private int indexOnProtein;

    public PeptideDraft() {
    }

    public PeptideDraft(char[] sequence) {
        this.sequence = sequence;
    }

    public PeptideDraft(char[] sequence, String nTermModification, HashMap<Integer, String> fixedAaModifications, double mass) {
        this.sequence = sequence;
        this.nTermModification = nTermModification;
        this.fixedAaModifications = fixedAaModifications;
        this.mass = mass;
    }

    public PeptideDraft(char[] sequence, String nTermModification, HashMap<Integer, String> fixedAaModifications, double mass, int missedCleavages) {
        this.sequence = sequence;
        this.nTermModification = nTermModification;
        this.fixedAaModifications = fixedAaModifications;
        this.mass = mass;
        this.missedCleavages = missedCleavages;
    }

    public PeptideDraft(char[] sequence, String nTermModification, String cTermModification, HashMap<Integer, String> fixedAaModifications, double mass) {
        this.sequence = sequence;
        this.nTermModification = nTermModification;
        this.cTermModification = cTermModification;
        this.fixedAaModifications = fixedAaModifications;
        this.mass = mass;
    }

    public PeptideDraft(char[] sequence, String nTermModification, String cTermModification, HashMap<Integer, String> fixedAaModifications, double mass, int missedCleavages) {
        this.sequence = sequence;
        this.nTermModification = nTermModification;
        this.cTermModification = cTermModification;
        this.fixedAaModifications = fixedAaModifications;
        this.mass = mass;
        this.missedCleavages = missedCleavages;
    }

    public PeptideDraft clone() {
        PeptideDraft newPeptideDraft = new PeptideDraft(Arrays.copyOf(this.sequence, this.sequence.length), this.nTermModification, this.cTermModification, new HashMap<Integer, String>(this.fixedAaModifications), this.mass, this.missedCleavages);
        return newPeptideDraft;
    }

    public char[] getSequence() {
        return this.sequence;
    }

    public void setSequence(char[] sequence) {
        this.sequence = sequence;
    }

    public int length() {
        return this.sequence.length;
    }

    public String getnTermModification() {
        return this.nTermModification;
    }

    public void setnTermModification(String nTermModification) {
        this.nTermModification = nTermModification;
    }

    public String getcTermModification() {
        return this.cTermModification;
    }

    public void setcTermModification(String cTermModification) {
        this.cTermModification = cTermModification;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public HashMap<Integer, String> getFixedAaModifications() {
        return this.fixedAaModifications;
    }

    public void setFixedAaModifications(HashMap<Integer, String> fixedAaModifications) {
        this.fixedAaModifications = fixedAaModifications;
    }

    public void increaseMissedCleavages() {
        ++this.missedCleavages;
    }

    public int getMissedCleavages() {
        return this.missedCleavages;
    }

    public void increaseNX() {
        ++this.nX;
    }

    public int getnX() {
        return this.nX;
    }

    public int getIndexOnProtein() {
        return this.indexOnProtein;
    }

    public void setIndexOnProtein(int indexOnProtein) {
        this.indexOnProtein = indexOnProtein;
    }

    public ExtendedPeptide getPeptide(double massMin, double massMax) {
        return this.getPeptide(massMin, massMax, new BoxedObject<Boolean>(Boolean.FALSE));
    }

    public ExtendedPeptide getPeptide(double massMin, double massMax, BoxedObject<Boolean> smallMass) {
        double peptideMass = this.getMass();
        double tempMass = peptideMass + ProteinIteratorUtils.WATER_MASS;
        if (massMax == 0.0 || tempMass <= massMax) {
            smallMass.setObject(Boolean.TRUE);
            if (tempMass >= massMin) {
                String[] fixedModifications = this.getFixedModifications();
                String peptideSequence = new String(this.getSequence());
                Peptide peptide = new Peptide(peptideSequence, null, false, tempMass);
                return new ExtendedPeptide(peptide, 0, fixedModifications);
            }
        }
        return null;
    }

    public String[] getFixedModifications() {
        String[] result = new String[this.sequence.length + 2];
        if (this.nTermModification != null) {
            result[0] = this.nTermModification;
        }
        if (this.cTermModification != null) {
            result[this.sequence.length + 1] = this.nTermModification;
        }
        for (int site : this.fixedAaModifications.keySet()) {
            String modificationName;
            result[site] = modificationName = this.fixedAaModifications.get(site);
        }
        return result;
    }
}

