/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_sequences.digestion.iterators;

import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.identification.protein_sequences.digestion.ExtendedPeptide;
import com.compomics.util.experiment.identification.protein_sequences.digestion.ProteinIteratorUtils;
import com.compomics.util.experiment.identification.protein_sequences.digestion.SequenceIterator;
import com.compomics.util.general.BoxedObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class SpecificSingleEnzymeIterator
implements SequenceIterator {
    private final ProteinIteratorUtils proteinIteratorUtils;
    private final String proteinSequence;
    private final char[] proteinSequenceAsCharArray;
    private final double massMin;
    private final double massMax;
    private final Enzyme enzyme;
    private final int nMissedCleavages;
    private HashMap<Integer, Integer> peptideStartMap;
    private int sequenceIndex = 0;
    private final ArrayList<ExtendedPeptide> result;
    private int resultIndex = -1;

    public SpecificSingleEnzymeIterator() {
        this.proteinIteratorUtils = null;
        this.proteinSequence = "";
        this.proteinSequenceAsCharArray = null;
        this.massMin = 0.0;
        this.massMax = 0.0;
        this.enzyme = null;
        this.nMissedCleavages = 0;
        this.result = null;
    }

    public SpecificSingleEnzymeIterator(ProteinIteratorUtils proteinIteratorUtils, String proteinSequence, Enzyme enzyme, int nMissedCleavages, double massMin, double massMax) {
        this.proteinIteratorUtils = proteinIteratorUtils;
        this.proteinSequence = proteinSequence;
        this.proteinSequenceAsCharArray = proteinSequence.toCharArray();
        this.enzyme = enzyme;
        this.nMissedCleavages = nMissedCleavages;
        this.massMin = massMin;
        this.massMax = massMax;
        this.peptideStartMap = new HashMap(nMissedCleavages + 1);
        this.result = new ArrayList(nMissedCleavages + 1);
    }

    @Override
    public ExtendedPeptide getNextPeptide() throws InterruptedException {
        ++this.resultIndex;
        if (this.resultIndex < this.result.size()) {
            return this.result.get(this.resultIndex);
        }
        if (this.sequenceIndex == this.proteinSequenceAsCharArray.length) {
            return null;
        }
        this.iterateSequence();
        return this.getNextPeptide();
    }

    private void iterateSequence() throws InterruptedException {
        int initialIndex = this.sequenceIndex;
        while (++this.sequenceIndex < this.proteinSequenceAsCharArray.length) {
            char aaBefore = this.proteinSequenceAsCharArray[this.sequenceIndex - 1];
            char aaAfter = this.proteinSequenceAsCharArray[this.sequenceIndex];
            if (!this.enzyme.isCleavageSiteNoCombination(Character.valueOf(aaBefore), Character.valueOf(aaAfter))) continue;
            break;
        }
        this.result.clear();
        char[] newSequence = Arrays.copyOfRange(this.proteinSequenceAsCharArray, initialIndex, this.sequenceIndex);
        BoxedObject<Boolean> smallMass = new BoxedObject<Boolean>(Boolean.TRUE);
        ExtendedPeptide extendedPeptide = this.proteinIteratorUtils.getPeptideFromProtein(newSequence, this.proteinSequence, initialIndex, this.massMin, this.massMax, smallMass);
        if (extendedPeptide != null && extendedPeptide.peptide.getMass() >= this.massMin && extendedPeptide.peptide.getMass() <= this.massMax) {
            this.result.add(new ExtendedPeptide(extendedPeptide.peptide, initialIndex, extendedPeptide.fixedModifications));
        }
        if (this.nMissedCleavages > 0) {
            if (smallMass.getObject().booleanValue()) {
                HashMap<Integer, Integer> newPeptideStartMap = new HashMap<Integer, Integer>(this.peptideStartMap.size());
                newPeptideStartMap.put(initialIndex, 0);
                for (int peptideStart : this.peptideStartMap.keySet()) {
                    newSequence = Arrays.copyOfRange(this.proteinSequenceAsCharArray, peptideStart, this.sequenceIndex);
                    smallMass.setObject(Boolean.TRUE);
                    extendedPeptide = this.proteinIteratorUtils.getPeptideFromProtein(newSequence, this.proteinSequence, peptideStart, this.massMin, this.massMax, smallMass);
                    if (extendedPeptide != null && extendedPeptide.peptide.getMass() >= this.massMin && extendedPeptide.peptide.getMass() <= this.massMax) {
                        this.result.add(new ExtendedPeptide(extendedPeptide.peptide, peptideStart, extendedPeptide.fixedModifications));
                    }
                    int peptideMissedCleavages = this.peptideStartMap.get(peptideStart);
                    if (!smallMass.getObject().booleanValue() || peptideMissedCleavages + 1 >= this.nMissedCleavages) continue;
                    newPeptideStartMap.put(peptideStart, peptideMissedCleavages + 1);
                }
                this.peptideStartMap = newPeptideStartMap;
            } else {
                this.peptideStartMap.clear();
            }
        }
        this.resultIndex = -1;
    }
}

