/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_sequences.digestion.iterators;

import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.identification.protein_sequences.AmbiguousSequenceIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.ExtendedPeptide;
import com.compomics.util.experiment.identification.protein_sequences.digestion.ProteinIteratorUtils;
import com.compomics.util.experiment.identification.protein_sequences.digestion.SequenceIterator;
import com.compomics.util.general.BoxedObject;
import java.util.Arrays;

public class UnspecificCombinationIterator
implements SequenceIterator {
    private final ProteinIteratorUtils proteinIteratorUtils;
    private final String proteinSequence;
    private final char[] proteinSequenceAsCharArray;
    private final double massMin;
    private final double massMax;
    private int index1 = 0;
    private int index2 = 0;
    AmbiguousSequenceIterator ambiguousSequenceIterator = null;

    public UnspecificCombinationIterator() {
        this.proteinIteratorUtils = null;
        this.proteinSequence = "";
        this.proteinSequenceAsCharArray = null;
        this.massMin = 0.0;
        this.massMax = 0.0;
    }

    public UnspecificCombinationIterator(ProteinIteratorUtils proteinIteratorUtils, String proteinSequence, double massMin, double massMax) {
        this.proteinIteratorUtils = proteinIteratorUtils;
        this.proteinSequence = proteinSequence;
        this.proteinSequenceAsCharArray = proteinSequence.toCharArray();
        this.massMin = massMin;
        this.massMax = massMax;
    }

    @Override
    public ExtendedPeptide getNextPeptide() throws InterruptedException {
        if (this.ambiguousSequenceIterator != null) {
            char[] sequence = this.ambiguousSequenceIterator.getNextSequence();
            if (sequence == null) {
                this.ambiguousSequenceIterator = null;
                return this.getNextPeptide();
            }
            ExtendedPeptide extendedPeptide = this.proteinIteratorUtils.getPeptideFromProtein(sequence, this.proteinSequence, this.index1, this.massMin, this.massMax);
            if (extendedPeptide != null && extendedPeptide.peptide.getMass() >= this.massMin && extendedPeptide.peptide.getMass() <= this.massMax) {
                return new ExtendedPeptide(extendedPeptide.peptide, this.index1, extendedPeptide.fixedModifications);
            }
            return this.getNextPeptide();
        }
        if (!this.increaseIndex()) {
            return null;
        }
        char[] sequence = Arrays.copyOfRange(this.proteinSequenceAsCharArray, this.index1, this.index2);
        if (AminoAcidSequence.hasCombination(sequence)) {
            this.ambiguousSequenceIterator = new AmbiguousSequenceIterator(sequence, this.proteinIteratorUtils.getMaxXsInSequence());
            return this.getNextPeptide();
        }
        BoxedObject<Boolean> smallMass = new BoxedObject<Boolean>(Boolean.TRUE);
        ExtendedPeptide extendedPeptide = this.proteinIteratorUtils.getPeptideFromProtein(sequence, this.proteinSequence, this.index1, this.massMin, this.massMax, smallMass);
        if (!smallMass.getObject().booleanValue()) {
            ++this.index1;
            if (this.index1 == this.proteinSequenceAsCharArray.length) {
                return null;
            }
            this.index2 = this.index1;
        }
        if (extendedPeptide != null && extendedPeptide.peptide.getMass() >= this.massMin && extendedPeptide.peptide.getMass() <= this.massMax) {
            return new ExtendedPeptide(extendedPeptide.peptide, this.index1, extendedPeptide.fixedModifications);
        }
        return this.getNextPeptide();
    }

    private boolean increaseIndex() {
        ++this.index2;
        if (this.index2 == this.proteinSequenceAsCharArray.length + 1) {
            ++this.index1;
            if (this.index1 == this.proteinSequenceAsCharArray.length) {
                return false;
            }
            this.index2 = this.index1 + 1;
        }
        return true;
    }
}

