/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.psm_scoring.psm_scores;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SimpleNoiseDistribution;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.math.util.FastMath;

public class SnrScore {
    private static final double limitLog10 = -FastMath.log10((double)Double.MIN_VALUE);

    public double getScore(Peptide peptide, String spectrumFile, String spectrumTitle, Spectrum spectrum, AnnotationParameters annotationSettings, SpecificAnnotationParameters specificAnnotationSettings, PeptideSpectrumAnnotator peptideSpectrumAnnotator, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters) {
        ArrayList ionMatches = Lists.newArrayList((Object[])peptideSpectrumAnnotator.getSpectrumAnnotation(annotationSettings, specificAnnotationSettings, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, false));
        return this.getScore(peptide, spectrum, ionMatches);
    }

    public double getScore(Peptide peptide, Spectrum spectrum, ArrayList<IonMatch> ionMatchesList) {
        HashMap<Double, ArrayList<IonMatch>> ionMatches = new HashMap<Double, ArrayList<IonMatch>>(ionMatchesList.size());
        for (IonMatch ionMatch : ionMatchesList) {
            double mz = ionMatch.peakMz;
            ArrayList<IonMatch> peakMatches = ionMatches.get(mz);
            if (peakMatches == null) {
                peakMatches = new ArrayList(1);
                ionMatches.put(mz, peakMatches);
            }
            peakMatches.add(ionMatch);
        }
        return this.getScore(peptide, spectrum, ionMatches);
    }

    public double getScore(Peptide peptide, Spectrum spectrum, HashMap<Double, ArrayList<IonMatch>> ionMatches) {
        char[] sequence = peptide.getSequence().toCharArray();
        SimpleNoiseDistribution binnedCumulativeFunction = new SimpleNoiseDistribution(spectrum.intensity);
        double pFragmentIonMinusLog = 0.0;
        double pAnnotatedMinusLog = 0.0;
        for (double mz : ionMatches.keySet()) {
            ArrayList<IonMatch> peakMatches = ionMatches.get(mz);
            double intensity = peakMatches.get((int)0).peakIntensity;
            double pMinusLog = -binnedCumulativeFunction.getBinnedCumulativeProbabilityLog(intensity);
            for (IonMatch ionMatch : peakMatches) {
                if (ionMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ionMatch.ion;
                int number = peptideFragmentIon.getNumber();
                if (peptideFragmentIon.hasNeutralLosses() || number < 2) continue;
                pFragmentIonMinusLog += pMinusLog;
                break;
            }
            pAnnotatedMinusLog += pMinusLog;
        }
        if (pFragmentIonMinusLog == 0.0) {
            return pFragmentIonMinusLog;
        }
        double pTotalMinusLog = 0.0;
        for (double intensity : spectrum.intensity) {
            double pMinusLog = -binnedCumulativeFunction.getBinnedCumulativeProbabilityLog(intensity);
            pTotalMinusLog += pMinusLog;
        }
        double pNotAnnotatedMinusLog = pTotalMinusLog - pAnnotatedMinusLog;
        if (pNotAnnotatedMinusLog < limitLog10) {
            double notAnnotatedCorrection;
            double pNotAnnotated = FastMath.pow((double)10.0, (double)(-pNotAnnotatedMinusLog));
            if (pNotAnnotated > 1.0) {
                pNotAnnotated = 1.0;
            }
            if ((notAnnotatedCorrection = -FastMath.log10((double)(pNotAnnotated = 1.0 - pNotAnnotated))) > pAnnotatedMinusLog) {
                notAnnotatedCorrection = pAnnotatedMinusLog;
            }
            pFragmentIonMinusLog += notAnnotatedCorrection;
        }
        return pFragmentIonMinusLog;
    }
}

