/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators;

import com.compomics.util.experiment.biology.ions.impl.ElementaryIon;
import com.compomics.util.experiment.biology.ions.impl.ImmoniumIon;
import com.compomics.util.experiment.biology.ions.impl.RelatedIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.mass_spectrometry.indexes.SpectrumIndex;
import java.util.ArrayList;
import java.util.Iterator;

public class ImmoniumIonAnnotator {
    private final char[] aas;
    private final double[] immoniumIonsMz;
    private RelatedIon[] relatedIons;
    private double[] relatedIonsMz;

    public ImmoniumIonAnnotator() {
        this.aas = null;
        this.immoniumIonsMz = null;
    }

    public ImmoniumIonAnnotator(char[] peptideSequence) {
        this(peptideSequence, true, true);
    }

    public ImmoniumIonAnnotator(char[] peptideSequence, boolean immonium, boolean related) {
        this.aas = peptideSequence;
        this.immoniumIonsMz = new double[peptideSequence.length];
        this.relatedIons = new RelatedIon[0];
        this.relatedIonsMz = new double[0];
        for (int i = 1; i < this.aas.length; ++i) {
            ArrayList<RelatedIon> aaRelatedIons;
            char aa = this.aas[i];
            if (immonium) {
                this.immoniumIonsMz[i] = ImmoniumIon.getImmoniumIon(aa).getTheoreticMass() + ElementaryIon.proton.getTheoreticMass();
            }
            if (!related || (aaRelatedIons = RelatedIon.getRelatedIons(aa)) == null) continue;
            int j = this.relatedIons.length;
            int newLength = j + aaRelatedIons.size();
            RelatedIon[] newIons = new RelatedIon[newLength];
            double[] newMz = new double[newLength];
            System.arraycopy(this.relatedIons, 0, newIons, 0, this.relatedIons.length);
            System.arraycopy(this.relatedIonsMz, 0, newMz, 0, this.relatedIonsMz.length);
            Iterator<RelatedIon> iterator = aaRelatedIons.iterator();
            while (iterator.hasNext()) {
                RelatedIon relatedIon;
                newIons[j] = relatedIon = iterator.next();
                newMz[j++] = relatedIon.getTheoreticMass() + ElementaryIon.proton.getTheoreticMass();
            }
            this.relatedIons = newIons;
            this.relatedIonsMz = newMz;
        }
    }

    public ArrayList<IonMatch> getIonMatches(SpectrumIndex spectrumIndex) {
        double ionMz;
        int i;
        ArrayList<IonMatch> results = new ArrayList<IonMatch>(0);
        for (i = 0; i < this.aas.length; ++i) {
            ionMz = this.immoniumIonsMz[i];
            char aa = this.aas[i];
            int[] indexes = spectrumIndex.getMatchingPeaks(ionMz);
            if (indexes.length <= 0) continue;
            ImmoniumIon ion = ImmoniumIon.getImmoniumIon(aa);
            int[] nArray = indexes;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int index = nArray[j];
                results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion, 1));
            }
        }
        for (i = 0; i < this.relatedIons.length; ++i) {
            ionMz = this.relatedIonsMz[i];
            int[] indexes = spectrumIndex.getMatchingPeaks(ionMz);
            if (indexes.length <= 0) continue;
            RelatedIon ion = this.relatedIons[i];
            for (int index : indexes) {
                results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion, 1));
            }
        }
        return results;
    }
}

