/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.utils;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.amino_acid_tags.TagComponent;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ModificationUtils {
    public static final int[] EMPTY = new int[0];
    public static final int[] ZERO = new int[]{0};
    public static final HashMap<Integer, int[]> ARRAYS_MAP = new HashMap();

    public static int[] getArray(int index) {
        int[] result = ARRAYS_MAP.get(index);
        if (result == null) {
            result = new int[]{index};
            ARRAYS_MAP.put(index, result);
        }
        return result;
    }

    public static int[] getPossibleModificationSites(Peptide peptide, Modification modification, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters) {
        return ModificationUtils.getPossibleModificationSites(peptide, modification, sequenceProvider, sequenceMatchingParameters, null, false);
    }

    public static int[] getPossibleModificationSites(Peptide peptide, Modification modification, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, ModificationProvider modificationProvider, boolean avoidOverlap) {
        String peptideSequence = peptide.getSequence();
        ModificationType modificationType = modification.getModificationType();
        if (modificationType == null) {
            throw new UnsupportedOperationException("Modification mapping not supported for modification of type " + (Object)((Object)modificationType) + ".");
        }
        switch (modificationType) {
            case modaa: {
                AminoAcidPattern aminoAcidPattern = modification.getPattern();
                if (aminoAcidPattern.length() == 1) {
                    int[] indexes = aminoAcidPattern.getIndexes(peptideSequence, sequenceMatchingParameters);
                    if (!avoidOverlap) {
                        return indexes;
                    }
                    HashSet occupiedSites = Arrays.stream(peptide.getVariableModifications()).filter(modificationMatch -> modificationProvider.getModification(modificationMatch.getModification()).getMass() != modification.getMass()).map(modificationMatch -> modificationMatch.getSite()).collect(Collectors.toCollection(HashSet::new));
                    return IntStream.of(indexes).filter(site -> !occupiedSites.contains(site)).toArray();
                }
                if (aminoAcidPattern.length() > 1) {
                    int minIndex = aminoAcidPattern.getMinIndex();
                    int maxIndex = aminoAcidPattern.getMaxIndex();
                    IntStream allPossibleIndexes = IntStream.empty();
                    for (Map.Entry<String, int[]> entry2 : peptide.getProteinMapping().entrySet()) {
                        String accession = entry2.getKey();
                        String sequence = sequenceProvider.getSequence(accession);
                        for (int startIndex : entry2.getValue()) {
                            StringBuilder extendedSequenceBuilder = new StringBuilder(peptideSequence.length() + aminoAcidPattern.length());
                            if (minIndex < 0) {
                                String prefix = sequence.substring(Math.max(startIndex + minIndex, 0), startIndex);
                                extendedSequenceBuilder.append(prefix);
                            }
                            extendedSequenceBuilder.append(peptideSequence);
                            if (maxIndex > 0) {
                                String suffix = sequence.substring(startIndex + peptideSequence.length(), Math.min(startIndex + peptideSequence.length() + maxIndex, sequence.length()));
                                extendedSequenceBuilder.append(suffix);
                            }
                            int[] sitesAtIndex = aminoAcidPattern.getIndexes(extendedSequenceBuilder.toString(), sequenceMatchingParameters);
                            allPossibleIndexes = IntStream.concat(allPossibleIndexes, Arrays.stream(sitesAtIndex));
                        }
                    }
                    allPossibleIndexes = allPossibleIndexes.distinct().sorted();
                    if (minIndex < 0) {
                        allPossibleIndexes.map(site -> site - minIndex);
                    }
                    if (!avoidOverlap) {
                        return allPossibleIndexes.toArray();
                    }
                    HashSet occupiedSites = Arrays.stream(peptide.getVariableModifications()).filter(modificationMatch -> modificationProvider.getModification(modificationMatch.getModification()).getMass() != modification.getMass()).map(modificationMatch -> modificationMatch.getSite()).collect(Collectors.toCollection(HashSet::new));
                    return allPossibleIndexes.filter(site -> !occupiedSites.contains(site)).toArray();
                }
                throw new IllegalArgumentException("No pattern set for modification " + modification.getName() + ".");
            }
            case modnaa_peptide: {
                AminoAcidPattern aminoAcidPattern = modification.getPattern();
                if (aminoAcidPattern.length() == 1) {
                    return aminoAcidPattern.matches(Character.toString(peptideSequence.charAt(0)), sequenceMatchingParameters) ? ZERO : EMPTY;
                }
                if (aminoAcidPattern.length() > 1) {
                    int minIndex = aminoAcidPattern.getMinIndex();
                    int maxIndex = aminoAcidPattern.getMaxIndex();
                    if (minIndex == 0 && maxIndex < peptideSequence.length()) {
                        return aminoAcidPattern.matchesAt(peptideSequence, sequenceMatchingParameters, 0) ? ZERO : EMPTY;
                    }
                    for (Map.Entry<String, int[]> entry3 : peptide.getProteinMapping().entrySet()) {
                        String accession = entry3.getKey();
                        String sequence = sequenceProvider.getSequence(accession);
                        for (int startIndex : entry3.getValue()) {
                            String subSequence;
                            int tempStart = startIndex + minIndex;
                            int tempEnd = startIndex + maxIndex + 1;
                            if (tempStart < 0 || tempEnd > sequence.length() || !aminoAcidPattern.matches(subSequence = sequence.substring(tempStart, tempEnd), sequenceMatchingParameters)) continue;
                            return ZERO;
                        }
                    }
                    return EMPTY;
                }
                throw new IllegalArgumentException("No pattern set for modification " + modification.getName() + ".");
            }
            case modn_protein: {
                return PeptideUtils.isNterm(peptide, sequenceProvider) ? ZERO : EMPTY;
            }
            case modn_peptide: {
                return new int[]{0};
            }
            case modnaa_protein: {
                String[] accessions = (String[])peptide.getProteinMapping().entrySet().stream().filter(entry -> Arrays.stream((int[])entry.getValue()).anyMatch(index -> index == 0)).map(entry -> (String)entry.getKey()).toArray(String[]::new);
                if (accessions.length > 0) {
                    AminoAcidPattern aminoAcidPattern = modification.getPattern();
                    if (aminoAcidPattern.length() == 1) {
                        return aminoAcidPattern.matches(Character.toString(peptideSequence.charAt(0)), sequenceMatchingParameters) ? ZERO : EMPTY;
                    }
                    if (aminoAcidPattern.length() > 1) {
                        int maxIndex = aminoAcidPattern.getMaxIndex();
                        if (maxIndex < peptideSequence.length()) {
                            return aminoAcidPattern.matchesAt(peptideSequence, sequenceMatchingParameters, 0) ? ZERO : EMPTY;
                        }
                        for (String accession : accessions) {
                            String sequence = sequenceProvider.getSequence(accession);
                            if (maxIndex >= sequence.length()) continue;
                            String subSequence = sequence.substring(0, maxIndex + 1);
                            if (aminoAcidPattern.matches(subSequence, sequenceMatchingParameters)) {
                                return ZERO;
                            }
                            if (sequence.charAt(0) != 'M' || maxIndex + 1 >= sequence.length() || !aminoAcidPattern.matches(subSequence = sequence.substring(1, maxIndex + 2), sequenceMatchingParameters)) continue;
                            return ZERO;
                        }
                    } else {
                        throw new IllegalArgumentException("No pattern set for modification " + modification.getName() + ".");
                    }
                }
                return EMPTY;
            }
            case modc_peptide: {
                return ModificationUtils.getArray(peptideSequence.length() + 1);
            }
            case modc_protein: {
                return PeptideUtils.isCterm(peptide, sequenceProvider) ? ModificationUtils.getArray(peptideSequence.length() + 1) : EMPTY;
            }
            case modcaa_peptide: {
                AminoAcidPattern aminoAcidPattern = modification.getPattern();
                if (aminoAcidPattern.length() == 1) {
                    return aminoAcidPattern.matches(Character.toString(peptideSequence.charAt(peptideSequence.length() - 1)), sequenceMatchingParameters) ? ModificationUtils.getArray(peptideSequence.length() + 1) : EMPTY;
                }
                if (aminoAcidPattern.length() > 1) {
                    int minIndex = aminoAcidPattern.getMinIndex();
                    int maxIndex = aminoAcidPattern.getMaxIndex();
                    int tempStart = peptideSequence.length() + minIndex;
                    if (maxIndex == 0 && tempStart > 0) {
                        return aminoAcidPattern.matchesAt(peptideSequence, sequenceMatchingParameters, peptideSequence.length() - 1) ? ModificationUtils.getArray(peptideSequence.length() + 1) : EMPTY;
                    }
                    for (Map.Entry<String, int[]> entry4 : peptide.getProteinMapping().entrySet()) {
                        String accession = entry4.getKey();
                        String sequence = sequenceProvider.getSequence(accession);
                        for (int startIndex : entry4.getValue()) {
                            String subSequence;
                            int tempStartProtein = startIndex + tempStart;
                            int tempEndProtein = startIndex + peptideSequence.length() + maxIndex + 1;
                            if (tempStartProtein < 0 || tempEndProtein > sequence.length() || !aminoAcidPattern.matches(subSequence = sequence.substring(tempStartProtein, tempEndProtein), sequenceMatchingParameters)) continue;
                            return ModificationUtils.getArray(peptideSequence.length() + 1);
                        }
                    }
                    return EMPTY;
                }
                throw new IllegalArgumentException("No pattern set for modification " + modification.getName() + ".");
            }
            case modcaa_protein: {
                String[] accessions = (String[])peptide.getProteinMapping().entrySet().stream().filter(entry -> Arrays.stream((int[])entry.getValue()).anyMatch(index -> index + peptideSequence.length() == sequenceProvider.getSequence((String)entry.getKey()).length())).map(entry -> (String)entry.getKey()).toArray(String[]::new);
                if (accessions.length > 0) {
                    AminoAcidPattern aminoAcidPattern = modification.getPattern();
                    if (aminoAcidPattern.length() == 1) {
                        return aminoAcidPattern.matches(Character.toString(peptideSequence.charAt(peptideSequence.length() - 1)), sequenceMatchingParameters) ? ModificationUtils.getArray(peptideSequence.length() + 1) : EMPTY;
                    }
                    if (aminoAcidPattern.length() > 1) {
                        int minIndex = aminoAcidPattern.getMinIndex();
                        int tempStart = peptideSequence.length() + minIndex;
                        if (tempStart > 0) {
                            return aminoAcidPattern.matchesAt(peptideSequence, sequenceMatchingParameters, peptideSequence.length() - 1) ? ModificationUtils.getArray(peptideSequence.length() + 1) : EMPTY;
                        }
                        for (String accession : accessions) {
                            String subSequence;
                            String sequence = sequenceProvider.getSequence(accession);
                            int tempStartProtein = sequence.length() - aminoAcidPattern.length() - 1;
                            if (tempStartProtein < 0 || !aminoAcidPattern.matches(subSequence = sequence.substring(tempStartProtein, sequence.length()), sequenceMatchingParameters)) continue;
                            return ModificationUtils.getArray(peptideSequence.length() + 1);
                        }
                    } else {
                        throw new IllegalArgumentException("No pattern set for modification " + modification.getName() + ".");
                    }
                }
                return EMPTY;
            }
        }
        throw new UnsupportedOperationException("Modification mapping not supported for modification of type " + (Object)((Object)modificationType) + ".");
    }

    public static int[] getPossibleModificationSites(AminoAcidSequence aminoAcidSequence, boolean nTerm, boolean cTerm, Modification modification, SequenceMatchingParameters sequenceMatchingParameters) {
        String sequence = aminoAcidSequence.getSequence();
        ModificationType modificationType = modification.getModificationType();
        if (null == modificationType) {
            throw new UnsupportedOperationException("Modification mapping not supported for modification of type " + (Object)((Object)modificationType) + ".");
        }
        switch (modificationType) {
            case modaa: {
                AminoAcidPattern aminoAcidPattern = modification.getPattern();
                return aminoAcidPattern.getIndexes(sequence, sequenceMatchingParameters);
            }
            case modnaa_peptide: {
                if (!nTerm) {
                    return EMPTY;
                }
                AminoAcidPattern aminoAcidPattern = modification.getPattern();
                return aminoAcidPattern.matchesAt(sequence, sequenceMatchingParameters, 0) ? ZERO : EMPTY;
            }
            case modn_protein: {
                return EMPTY;
            }
            case modn_peptide: {
                return nTerm ? ZERO : EMPTY;
            }
            case modnaa_protein: {
                return EMPTY;
            }
            case modc_peptide: {
                return cTerm ? ModificationUtils.getArray(sequence.length() + 1) : EMPTY;
            }
            case modc_protein: {
                return EMPTY;
            }
            case modcaa_peptide: {
                if (!cTerm) {
                    return EMPTY;
                }
                AminoAcidPattern aminoAcidPattern = modification.getPattern();
                return aminoAcidPattern.matchesAt(sequence, sequenceMatchingParameters, sequence.length() - 1) ? ModificationUtils.getArray(sequence.length() + 1) : EMPTY;
            }
            case modcaa_protein: {
                return EMPTY;
            }
        }
        throw new UnsupportedOperationException("Modification mapping not supported for modification of type " + (Object)((Object)modificationType) + ".");
    }

    public static String getTaggedModifiedSequence(ModificationParameters modificationProfile, String sequence, String[] confidentModificationSites, String[] representativeAmbiguousModificationSites, String[] secondaryAmbiguousModificationSites, String[] fixedModificationSites, boolean useHtmlColorCoding, boolean useShortName) {
        if (confidentModificationSites == null) {
            confidentModificationSites = new String[sequence.length() + 2];
        }
        if (representativeAmbiguousModificationSites == null) {
            representativeAmbiguousModificationSites = new String[sequence.length() + 2];
        }
        if (secondaryAmbiguousModificationSites == null) {
            secondaryAmbiguousModificationSites = new String[sequence.length() + 2];
        }
        if (fixedModificationSites == null) {
            fixedModificationSites = new String[sequence.length() + 2];
        }
        StringBuilder modifiedSequence = new StringBuilder(sequence.length());
        for (int aa = 1; aa <= sequence.length(); ++aa) {
            int aaIndex = aa - 1;
            char aminoAcid = sequence.charAt(aaIndex);
            ModificationUtils.appendTaggedResidue(modifiedSequence, aminoAcid, confidentModificationSites[aa], representativeAmbiguousModificationSites[aa], secondaryAmbiguousModificationSites[aa], fixedModificationSites[aa], modificationProfile, useHtmlColorCoding, useShortName);
        }
        return modifiedSequence.toString();
    }

    public static void appendTaggedResidue(StringBuilder stringBuilder, char residue, String confidentModification, String representativeAmbiguousModification, String secondaryAmbiguousModification, String fixedModification, ModificationParameters modificationProfile, boolean useHtmlColorCoding, boolean useShortName) {
        if (confidentModification != null) {
            ModificationUtils.appendTaggedResidue(stringBuilder, residue, confidentModification, modificationProfile, 1, useHtmlColorCoding, useShortName);
        } else if (representativeAmbiguousModification != null) {
            ModificationUtils.appendTaggedResidue(stringBuilder, residue, representativeAmbiguousModification, modificationProfile, 2, useHtmlColorCoding, useShortName);
        } else if (secondaryAmbiguousModification != null) {
            ModificationUtils.appendTaggedResidue(stringBuilder, residue, secondaryAmbiguousModification, modificationProfile, 3, useHtmlColorCoding, useShortName);
        } else if (fixedModification != null) {
            ModificationUtils.appendTaggedResidue(stringBuilder, residue, fixedModification, modificationProfile, 1, useHtmlColorCoding, useShortName);
        } else {
            stringBuilder.append(residue);
        }
    }

    public static void appendTaggedResidue(StringBuilder stringBuilder, char residue, String modificationName, ModificationParameters modificationProfile, int localizationConfidenceLevel, boolean useHtmlColorCoding, boolean useShortName) {
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        Modification modification = modificationFactory.getModification(modificationName);
        if (!useHtmlColorCoding) {
            if (localizationConfidenceLevel == 1 || localizationConfidenceLevel == 2) {
                if (useShortName) {
                    stringBuilder.append(residue).append("<").append(modification.getShortName()).append(">");
                } else {
                    stringBuilder.append(residue).append("<").append(modificationName).append(">");
                }
            } else if (localizationConfidenceLevel == 3) {
                stringBuilder.append(residue);
            }
        } else {
            int modificationColor = modificationProfile.getColor(modificationName);
            switch (localizationConfidenceLevel) {
                case 1: {
                    stringBuilder.append("<span style=\"color:#").append(Util.color2Hex(Color.WHITE)).append(";background:#").append(Util.color2Hex(modificationColor)).append("\">").append(residue).append("</span>");
                    break;
                }
                case 2: {
                    stringBuilder.append("<span style=\"color:#").append(Util.color2Hex(modificationColor)).append(";background:#").append(Util.color2Hex(Color.WHITE)).append("\">").append(residue).append("</span>");
                    break;
                }
                case 3: {
                    stringBuilder.append(residue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No formatting implemented for localization confidence level " + localizationConfidenceLevel + ".");
                }
            }
        }
    }

    public static int getSite(int index, int sequenceLength) {
        if (index > 0 && index < sequenceLength + 1) {
            return index;
        }
        if (index == 0) {
            return 1;
        }
        return index - 1;
    }

    public static HashSet<String> getAllModifications(Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters) {
        HashSet modNames = Arrays.stream(peptide.getVariableModifications()).map(ModificationMatch::getModification).collect(Collectors.toCollection(HashSet::new));
        String[] fixedModifications = peptide.getFixedModifications(modificationParameters, sequenceProvider, sequenceMatchingParameters);
        modNames.addAll(Arrays.stream(fixedModifications).filter(modName -> modName != null).collect(Collectors.toSet()));
        return modNames;
    }

    public static HashSet<String> getAllModifications(Tag tag, ModificationParameters modificationParameters, SequenceMatchingParameters sequenceMatchingParameters) {
        HashSet<String> modNames = new HashSet<String>(2);
        ArrayList<TagComponent> tagComponents = tag.getContent();
        for (int i = 0; i < tagComponents.size(); ++i) {
            TagComponent tagComponent = tagComponents.get(i);
            if (!(tagComponent instanceof AminoAcidSequence)) continue;
            AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
            modNames.addAll(Arrays.stream(aminoAcidSequence.getVariableModifications()).map(ModificationMatch::getModification).collect(Collectors.toCollection(HashSet::new)));
            String[] fixedModifications = aminoAcidSequence.getFixedModifications(i == 0, i == tagComponents.size() - 1, modificationParameters, sequenceMatchingParameters);
            modNames.addAll(Arrays.stream(fixedModifications).filter(modName -> modName != null).collect(Collectors.toSet()));
        }
        return modNames;
    }

    public static HashMap<Integer, HashSet<String>> getExpectedModifications(double modMass, ModificationParameters modificationParameters, Peptide peptide, double massTolerance, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, SearchParameters searchParameters) {
        HashMap<Integer, HashSet<String>> results = new HashMap<Integer, HashSet<String>>(1);
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        for (String possibleModName : modificationFactory.getExpectedVariableModifications(searchParameters)) {
            int[] possibleSites;
            Modification possibleModification = modificationFactory.getModification(possibleModName);
            if (!(Math.abs(modMass - possibleModification.getMass()) < massTolerance)) continue;
            for (int site : possibleSites = ModificationUtils.getPossibleModificationSites(peptide, possibleModification, sequenceProvider, sequenceMatchingParameters)) {
                HashSet<String> modifications = results.get(site);
                if (modifications == null) {
                    modifications = new HashSet(1);
                    results.put(site, modifications);
                }
                modifications.add(possibleModName);
            }
        }
        return results;
    }
}

