/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.biology.protein;

import com.compomics.util.Util;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.Header;
import com.compomics.util.experiment.io.biology.protein.ProteinDatabase;
import com.compomics.util.experiment.io.biology.protein.iterators.HeaderIterator;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.json.JsonMarshaller;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class FastaSummary {
    public final File fastaFile;
    public final TreeMap<String, Integer> speciesOccurrence;
    public final HashMap<ProteinDatabase, Integer> databaseType;
    public final int nSequences;
    public final int nTarget;
    public final long lastModified;
    private String name;
    private String description;
    private String version;

    public FastaSummary() {
        this.fastaFile = null;
        this.speciesOccurrence = null;
        this.databaseType = null;
        this.nSequences = 0;
        this.nTarget = 0;
        this.lastModified = 0L;
    }

    public FastaSummary(String name, String description, String version, File fastaFile, TreeMap<String, Integer> speciesOccurrence, HashMap<ProteinDatabase, Integer> databaseType, int nSequences, int nTarget, long lastModified) {
        this.name = name;
        this.description = description;
        this.version = version;
        this.fastaFile = fastaFile;
        this.speciesOccurrence = speciesOccurrence;
        this.databaseType = databaseType;
        this.nSequences = nSequences;
        this.nTarget = nTarget;
        this.lastModified = lastModified;
    }

    public static FastaSummary getSummary(String fastaFile, FastaParameters fastaParameters, WaitingHandler waitingHandler) throws IOException {
        return FastaSummary.getSummary(fastaFile, fastaParameters, false, waitingHandler);
    }

    public static FastaSummary getSummary(String fastaFile, FastaParameters fastaParameters, boolean alwaysCreateNew, WaitingHandler waitingHandler) throws IOException {
        FastaSummary fastaSummary = null;
        if (!alwaysCreateNew) {
            try {
                fastaSummary = FastaSummary.getSavedSummary(fastaFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fastaSummary == null && (fastaSummary = FastaSummary.parseSummary(fastaFile, fastaParameters, waitingHandler)) != null) {
            try {
                FastaSummary.saveSummary(fastaFile, fastaSummary);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fastaSummary;
    }

    private static FastaSummary getSavedSummary(String fastaFile) throws IOException {
        File savedFile = FastaSummary.getSummaryFile(fastaFile);
        if (savedFile.exists()) {
            JsonMarshaller marshaller = new JsonMarshaller();
            FastaSummary fastaSummary = (FastaSummary)marshaller.fromJson(FastaSummary.class, savedFile);
            return fastaSummary;
        }
        return null;
    }

    public static void saveSummary(String fastaFile, FastaSummary fastaSummary) throws IOException {
        File destinationFile = FastaSummary.getSummaryFile(fastaFile);
        File destinationFolder = destinationFile.getParentFile();
        if (!destinationFolder.exists() && !destinationFolder.mkdir()) {
            return;
        }
        JsonMarshaller marshaller = new JsonMarshaller();
        marshaller.saveObjectToJson(fastaSummary, destinationFile);
    }

    private static File getSummaryFile(String fastaFile) {
        UtilitiesUserParameters utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        File summaryFolder = utilitiesUserParameters.getDbSummaryFolder();
        int pathHash = fastaFile.hashCode();
        return new File(summaryFolder, Integer.toString(pathHash));
    }

    private static FastaSummary parseSummary(String fastaFilePath, FastaParameters fastaParameters, WaitingHandler waitingHandler) throws IOException {
        String fastaHeader;
        File fastaFile = new File(fastaFilePath);
        long lastModified = fastaFile.lastModified();
        TreeMap<String, Integer> speciesOccurrence = new TreeMap<String, Integer>();
        HashMap<ProteinDatabase, Integer> databaseType = new HashMap<ProteinDatabase, Integer>(1);
        TreeSet<String> accessionNumbers = new TreeSet<String>();
        int nSequences = 0;
        int nTarget = 0;
        HeaderIterator headerIterator = new HeaderIterator(fastaFile);
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(100);
        }
        while ((fastaHeader = headerIterator.getNextHeader(waitingHandler)) != null) {
            Integer occurrence;
            Header header = Header.parseFromFASTA(fastaHeader);
            String accession = header.getAccessionOrRest();
            boolean newAccession = accessionNumbers.add(accession);
            if (!newAccession) {
                throw new IOException("Duplicated accession number: " + accession);
            }
            String species = header.getTaxonomy();
            if (species == null) {
                species = "Unknown";
            }
            if ((occurrence = (Integer)speciesOccurrence.get(species)) == null) {
                speciesOccurrence.put(species, 1);
            } else {
                speciesOccurrence.put(species, occurrence + 1);
            }
            ProteinDatabase proteinDatabase = header.getDatabaseType();
            if (proteinDatabase == null) {
                proteinDatabase = ProteinDatabase.Unknown;
            }
            if ((occurrence = databaseType.get((Object)proteinDatabase)) == null) {
                databaseType.put(proteinDatabase, 1);
            } else {
                databaseType.put(proteinDatabase, occurrence + 1);
            }
            if (!ProteinUtils.isDecoy(accession, fastaParameters)) {
                ++nTarget;
            }
            ++nSequences;
            if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
            return null;
        }
        return new FastaSummary(IoUtil.removeExtension(fastaFile.getName()), fastaFile.getAbsolutePath(), new Date(fastaFile.lastModified()).toString(), fastaFile, speciesOccurrence, databaseType, nSequences, nTarget, lastModified);
    }

    public String getTypeAsString() {
        if (this.databaseType.isEmpty()) {
            return "Unknown";
        }
        if (this.databaseType.size() == 1) {
            return ((ProteinDatabase)((Object)this.databaseType.keySet().stream().findAny().get())).getFullName();
        }
        int sum = this.databaseType.values().stream().mapToInt(Integer::intValue).sum();
        return this.databaseType.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<ProteinDatabase, Double>((ProteinDatabase)((Object)((Object)entry.getKey())), (double)((Integer)entry.getValue()).intValue() / (double)sum)).map(entry -> ((ProteinDatabase)((Object)((Object)entry.getKey()))).getFullName() + " (" + Util.roundDouble((Double)entry.getValue(), 1) + "%)").collect(Collectors.joining(", "));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean containsDecoys() {
        return this.nTarget < this.nSequences;
    }
}

