/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.biology.protein.converters;

import com.compomics.util.experiment.biology.proteins.Protein;
import com.compomics.util.experiment.io.biology.protein.Header;
import com.compomics.util.experiment.io.biology.protein.iterators.FastaIterator;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class GenericFastaConverter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void convertFile(File fastaIn, File fastaOut, WaitingHandler waitingHandler) throws IOException {
        if (!fastaOut.getParentFile().exists()) {
            fastaOut.getParentFile().mkdirs();
        }
        FastaIterator fastaIterator = new FastaIterator(fastaIn);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(fastaOut));){
            Protein protein;
            while ((protein = fastaIterator.getNextProtein()) != null) {
                Header header = fastaIterator.getLastHeader();
                String genericHeader = header.asGenericHeader();
                bw.write(genericHeader);
                bw.newLine();
                bw.write(protein.getSequence());
                bw.newLine();
                bw.newLine();
                if (waitingHandler == null) continue;
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                waitingHandler.increaseSecondaryProgressCounter();
            }
            return;
        }
    }
}

