/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification;

public enum MzIdentMLVersion {
    v1_1("v1.1", "Version 1.1"),
    v1_2("v1.2", "Version 1.2");

    public final String name;
    public final String description;

    private MzIdentMLVersion(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public static MzIdentMLVersion getMzIdentMLVersion(int index) {
        MzIdentMLVersion[] versions = MzIdentMLVersion.values();
        if (index < 0 || index >= versions.length) {
            throw new IllegalArgumentException("No mzIdentML version found for index " + index + ".");
        }
        return MzIdentMLVersion.values()[index];
    }

    public static String getCommandLineOptions() {
        StringBuilder stringBuilder = new StringBuilder();
        MzIdentMLVersion[] versions = MzIdentMLVersion.values();
        stringBuilder.append(0).append(": ").append(versions[0].name);
        for (int i = 1; i < versions.length; ++i) {
            stringBuilder.append(", ").append(i).append(": ").append(versions[i].name);
        }
        return stringBuilder.toString();
    }

    private MzIdentMLVersion() {
        this.name = "";
        this.description = "";
    }
}

