/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.idfilereaders;

import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import org.apache.commons.math.util.FastMath;

public class AndromedaIdfileReader
implements IdfileReader {
    private File resultsFile;
    private String fileName;

    public AndromedaIdfileReader() {
    }

    public AndromedaIdfileReader(File resultsFile) {
        this.resultsFile = resultsFile;
        this.fileName = IoUtil.getFileName(resultsFile);
    }

    @Override
    public String getExtension() {
        return ".res";
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, false);
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        String mgfFile = AndromedaIdfileReader.getMgfFileName(this.fileName);
        ArrayList<SpectrumMatch> result = new ArrayList<SpectrumMatch>();
        HashMap<String, SpectrumMatch> spectrumMatchesMap = new HashMap<String, SpectrumMatch>();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.resultsFile);){
            String line;
            String title = null;
            SpectrumMatch spectrumMatch = null;
            int rank = 0;
            boolean firstSpectrum = false;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(">")) {
                    if (!firstSpectrum) {
                        firstSpectrum = true;
                    }
                    title = line.substring(1).trim();
                    title = URLDecoder.decode(title, "utf-8");
                    spectrumMatch = null;
                    continue;
                }
                if (!firstSpectrum) continue;
                if (spectrumMatch == null) {
                    spectrumMatch = (SpectrumMatch)spectrumMatchesMap.get(title);
                    rank = 0;
                    if (spectrumMatch == null) {
                        spectrumMatch = new SpectrumMatch(mgfFile, title);
                        result.add(spectrumMatch);
                        spectrumMatchesMap.put(title, spectrumMatch);
                    }
                }
                PeptideAssumption peptideAssumption = this.getAssumptionFromLine(line, ++rank);
                if (expandAaCombinations && AminoAcidSequence.hasCombination(peptideAssumption.getPeptide().getSequence())) {
                    Peptide peptide = peptideAssumption.getPeptide();
                    ModificationMatch[] previousModificationMatches = peptide.getVariableModifications();
                    for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                        ModificationMatch[] newModificationMatches = (ModificationMatch[])Arrays.stream(previousModificationMatches).map(modificationMatch -> modificationMatch.clone()).toArray(ModificationMatch[]::new);
                        Peptide newPeptide = new Peptide(expandedSequence.toString(), newModificationMatches, true);
                        PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getRawScore(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                        spectrumMatch.addPeptideAssumption(Advocate.andromeda.getIndex(), newAssumption);
                    }
                    continue;
                }
                spectrumMatch.addPeptideAssumption(Advocate.andromeda.getIndex(), peptideAssumption);
            }
            ArrayList<SpectrumMatch> arrayList = result;
            return arrayList;
        }
    }

    private PeptideAssumption getAssumptionFromLine(String line, int rank) {
        String[] temp = line.trim().split("\t");
        String[] temp1 = temp[4].split(",");
        ArrayList<ModificationMatch> modMatches = new ArrayList<ModificationMatch>();
        for (int aa = 0; aa < temp1.length; ++aa) {
            String mod = temp1[aa];
            if (mod.equals("A")) continue;
            modMatches.add(new ModificationMatch(mod, aa + 1));
        }
        String sequence = temp[0];
        Peptide peptide = new Peptide(sequence, modMatches.toArray(new ModificationMatch[modMatches.size()]), true);
        int charge = Integer.parseInt(temp[6]);
        Double score = Double.valueOf(temp[1]);
        Double p = FastMath.pow((double)10.0, (double)(-(score / 10.0)));
        PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, rank, Advocate.andromeda.getIndex(), charge, score, p, this.fileName);
        return peptideAssumption;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>(1);
        ArrayList<String> versions = new ArrayList<String>(1);
        versions.add("1.5.3.4");
        result.put("Andromeda", versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return false;
    }

    public static String getMgfFileName(String fileName) {
        if (fileName.endsWith(".res.gz")) {
            return fileName.substring(0, fileName.length() - 7) + ".mgf";
        }
        if (fileName.endsWith(".res")) {
            return fileName.substring(0, fileName.length() - 4) + ".mgf";
        }
        throw new IllegalArgumentException("Unexpected file extension. Expected: .res or .res.gz. File name: " + fileName + ".");
    }
}

