/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.idfilereaders;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.DirecTagParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.JAXBException;

public class DirecTagIdfileReader
implements IdfileReader {
    private String tagsGenerator;
    private String tagsGeneratorVersion;
    private String copyRight;
    private String license;
    private String timeStart;
    private String timeEnd;
    private Double taggingTimeSeconds;
    private Integer nProcessingNode;
    private String inputFile;
    private final HashMap<String, String> tagsParameters = new HashMap();
    private final HashMap<String, Integer> spectrumLineContent = new HashMap();
    private final HashMap<String, Integer> tagLineContent = new HashMap();
    private File tagFile;
    public final double cTermCorrection = 0.0;
    public final double nTermCorrection = 0.0;
    private DirecTagParameters direcTagParameters;
    private HashMap<Character, Character> dynamicModsResidues;

    public DirecTagIdfileReader() {
    }

    public DirecTagIdfileReader(File tagFile) {
        this.tagFile = tagFile;
    }

    public Set<String> getTagsParametersNames() {
        return this.tagsParameters.keySet();
    }

    public String getTagParameter(String tagParameterName) {
        return this.tagsParameters.get(tagParameterName);
    }

    private boolean parseParameters(SimpleFileReader reader) {
        String line;
        while ((line = reader.readLine()) != null && line != null && !line.startsWith("H\tTagsParameters")) {
            if (line == null) {
                throw new IllegalArgumentException("Unexpected end of file while parsing the parameters.");
            }
            if (line.startsWith("H(S)") || line.startsWith("H(T)") || line.startsWith("S") || line.startsWith("T")) {
                throw new IllegalArgumentException("Unexpected end of parameters section.");
            }
            if ((line = line.substring(1).trim()).startsWith("TagsGeneratorVersion")) {
                this.tagsGeneratorVersion = line.substring(line.indexOf("\t")).trim();
                continue;
            }
            if (line.startsWith("TagsGenerator")) {
                this.tagsGenerator = line.substring(line.indexOf("\t")).trim();
                continue;
            }
            if (line.contains("(c)")) {
                this.copyRight = line;
                continue;
            }
            if (line.contains("License")) {
                this.license = line;
                continue;
            }
            if (line.startsWith("Tagging started at")) {
                this.tagsGeneratorVersion = line.substring(line.indexOf("Tagging started at")).trim();
                continue;
            }
            if (line.startsWith("Tagging started at")) {
                this.timeStart = line.substring(line.indexOf("Tagging started at")).trim();
                continue;
            }
            if (line.startsWith("Tagging finished at")) {
                this.timeEnd = line.substring(line.indexOf("Tagging finished at")).trim();
                continue;
            }
            if (line.startsWith("Total tagging time:")) {
                line = line.substring(line.indexOf(":") + 1).trim();
                line = line.substring(0, line.indexOf(" ")).trim();
                try {
                    this.taggingTimeSeconds = Double.valueOf(line);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (line.contains("node")) {
                line = line.substring(line.indexOf(" ")).trim();
                line = line.substring(0, line.indexOf(" ")).trim();
                try {
                    this.nProcessingNode = Integer.valueOf(line);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!line.startsWith("InputFile")) continue;
            this.inputFile = line.substring(line.indexOf("\t")).trim();
        }
        return line == null;
    }

    private boolean parseTagParameters(SimpleFileReader reader) {
        String line;
        while ((line = reader.readLine()) != null && !line.trim().isEmpty()) {
            String[] components;
            if (line == null) {
                throw new IllegalArgumentException("Unexpected end of file while parsing the tag parameters.");
            }
            if (line.startsWith("H(S)") || line.startsWith("H(T)") || line.startsWith("S") || line.startsWith("T")) {
                throw new IllegalArgumentException("Unexpected end of tag parameters section.");
            }
            line = line.substring(1).trim();
            for (String component : components = line.split(", ")) {
                int index = component.indexOf(": ");
                if (index == -1) continue;
                String key = component.substring(0, index).trim();
                String value = component.substring(index + 1).trim();
                this.tagsParameters.put(key, value);
            }
        }
        return line == null;
    }

    private boolean parseHeaders(SimpleFileReader reader) {
        String line = reader.readLine();
        if (line != null) {
            this.parseHeaderLine(line);
        }
        if ((line = reader.readLine()) != null) {
            this.parseHeaderLine(line);
        }
        return line == null;
    }

    private void parseHeaderLine(String line) {
        block4: {
            block3: {
                if (line.startsWith("S") || line.startsWith("T")) {
                    throw new IllegalArgumentException("No Header found.");
                }
                if (!line.startsWith("H(S)")) break block3;
                line = line.substring(4).trim();
                String[] components = line.split("\t");
                for (int i = 0; i < components.length; ++i) {
                    this.spectrumLineContent.put(components[i], i);
                }
                break block4;
            }
            if (!line.startsWith("H(T)")) break block4;
            line = line.substring(4).trim();
            String[] components = line.split("\t");
            for (int i = 0; i < components.length; ++i) {
                this.tagLineContent.put(components[i], i);
            }
        }
    }

    private void setDynamicMods() {
        this.dynamicModsResidues = new HashMap();
        String dynamicMods = this.tagsParameters.get("DynamicMods");
        if (!(dynamicMods = dynamicMods.trim()).isEmpty()) {
            String[] modElements = dynamicMods.split(" ");
            int index = 0;
            while (index + 2 < modElements.length) {
                this.dynamicModsResidues.put(Character.valueOf(modElements[index + 1].charAt(0)), Character.valueOf(modElements[index].charAt(0)));
                index += 3;
            }
        }
    }

    private ArrayList<SpectrumMatch> parseResults(SimpleFileReader reader, String[] spectrumTitles) {
        String line;
        ArrayList<SpectrumMatch> result = new ArrayList<SpectrumMatch>();
        String spectrumFileName = IoUtil.getFileName(this.getInputFile());
        int spectrumCount = 0;
        Integer sIdColumnIndex = this.spectrumLineContent.get("ID");
        Integer chargeColumnIndex = this.spectrumLineContent.get("Charge");
        int lastId = -1;
        int lastCharge = -1;
        int rank = 0;
        SpectrumMatch currentMatch = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("S")) {
                int sId = ++spectrumCount;
                rank = 0;
                if (sIdColumnIndex != null) {
                    line = line.substring(1).trim();
                    String[] components = line.split("\t");
                    String id = components[sIdColumnIndex];
                    sId = Integer.parseInt(id.substring(id.indexOf("=") + 1));
                    String chargeString = components[chargeColumnIndex];
                    lastCharge = Integer.parseInt(chargeString);
                }
                if (sId == lastId) continue;
                if (currentMatch != null && currentMatch.getAllTagAssumptions().count() > 0L) {
                    result.add(currentMatch);
                }
                String spectrumTitle = spectrumTitles[sId];
                currentMatch = new SpectrumMatch(spectrumFileName, spectrumTitle);
                lastId = sId;
                continue;
            }
            if (!line.startsWith("T")) continue;
            TagAssumption tagAssumption = this.getAssumptionFromLine(line, ++rank);
            tagAssumption.setIdentificationCharge(lastCharge);
            currentMatch.addTagAssumption(Advocate.direcTag.getIndex(), tagAssumption);
        }
        if (currentMatch != null && currentMatch.getAllTagAssumptions().count() > 0L) {
            result.add(currentMatch);
        }
        return result;
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, false);
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        this.direcTagParameters = (DirecTagParameters)searchParameters.getAlgorithmSpecificParameters().get(Advocate.direcTag.getIndex());
        ArrayList<SpectrumMatch> result = new ArrayList<SpectrumMatch>(0);
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.tagFile);){
            boolean endOfFile = this.parseParameters(reader);
            if (!endOfFile) {
                endOfFile = this.parseTagParameters(reader);
            }
            if (!endOfFile) {
                endOfFile = this.parseHeaders(reader);
            }
            if (!endOfFile) {
                this.setDynamicMods();
                result = this.parseResults(reader, spectrumProvider.getSpectrumTitles(IoUtil.removeExtension(this.getInputFile().getName())));
            }
        }
        return result;
    }

    private TagAssumption getAssumptionFromLine(String line, int rank) {
        Integer nGapIndex;
        line = line.substring(1).trim();
        String[] components = line.split("\t");
        Integer cGapIndex = this.tagLineContent.get("cTerminusMass");
        if (cGapIndex == null) {
            throw new IllegalArgumentException("Column cTerminusMass not found.");
        }
        Double cGap = Double.valueOf(components[cGapIndex]);
        if (cGap > 0.0 && cGap < 0.0) {
            throw new IllegalArgumentException("Incompatible c-term gap " + cGap);
        }
        if (cGap > 0.0) {
            cGap = cGap + 0.0;
        }
        if ((nGapIndex = this.tagLineContent.get("nTerminusMass")) == null) {
            throw new IllegalArgumentException("Column nTerminusMass not found.");
        }
        Double nGap = Double.valueOf(components[nGapIndex]);
        Integer tagIndex = this.tagLineContent.get("Tag");
        if (tagIndex == null) {
            throw new IllegalArgumentException("Column Tag not found.");
        }
        String tagSequence = components[tagIndex];
        StringBuilder residues = new StringBuilder(tagSequence.length());
        HashMap<Integer, ModificationMatch> modificationMatches = new HashMap<Integer, ModificationMatch>();
        for (int i = 0; i < tagSequence.length(); ++i) {
            char charAtI = tagSequence.charAt(i);
            try {
                AminoAcid aa = AminoAcid.getAminoAcid(charAtI);
                residues.append(aa.singleLetterCode);
                continue;
            }
            catch (IllegalArgumentException e) {
                try {
                    String modIndexString = charAtI + "";
                    int modIndex = Integer.valueOf(modIndexString);
                    String utilitiesPtm = this.direcTagParameters.getUtilitiesModificationName(modIndex);
                    modificationMatches.put(i + 1, new ModificationMatch(utilitiesPtm, i + 1));
                    residues.append(this.dynamicModsResidues.get(Character.valueOf(modIndexString.charAt(0))));
                    continue;
                }
                catch (Exception e1) {
                    throw new IllegalArgumentException("No amino acid or modification could be mapped to tag component \"" + charAtI + "\" in tag \"" + tagSequence + "\".");
                }
            }
        }
        AminoAcidSequence tagAaSequence = new AminoAcidSequence(residues.toString());
        Iterator charAtI = modificationMatches.keySet().iterator();
        while (charAtI.hasNext()) {
            int i = (Integer)charAtI.next();
            tagAaSequence.addVariableModification((ModificationMatch)modificationMatches.get(i));
        }
        Tag tag = new Tag(nGap, tagAaSequence, cGap);
        Integer chargeIndex = this.tagLineContent.get("TagChargeState");
        if (chargeIndex == null) {
            throw new IllegalArgumentException("Column TagChargeState not found.");
        }
        int charge = Integer.valueOf(components[chargeIndex]);
        Integer eValueIndex = this.tagLineContent.get("Total");
        if (eValueIndex == null) {
            throw new IllegalArgumentException("Column Total not found.");
        }
        double eValue = Double.valueOf(components[eValueIndex]);
        return new TagAssumption(Advocate.direcTag.getIndex(), rank, tag, charge, eValue, eValue);
    }

    public String getTagsGenerator() {
        return this.tagsGenerator;
    }

    public String getTagsGeneratorVersion() {
        return this.tagsGeneratorVersion;
    }

    public String getCopyRight() {
        return this.copyRight;
    }

    public String getLicense() {
        return this.license;
    }

    public String getTimeStart() {
        return this.timeStart;
    }

    public String getTimeEnd() {
        return this.timeEnd;
    }

    public Double getTaggingTimeSeconds() {
        return this.taggingTimeSeconds;
    }

    public Integer getnProcessingNode() {
        return this.nProcessingNode;
    }

    public File getInputFile() {
        return new File(this.inputFile);
    }

    @Override
    public String getExtension() {
        return ".tags";
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.tagsGeneratorVersion);
        result.put(this.tagsGenerator, versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return true;
    }
}

