/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.bind.JAXBException;

public class TideIdfileReader
extends ExperimentObject
implements IdfileReader {
    private final String softwareName = "Tide";
    private String softwareVersion = null;
    private File tideTsvFile;

    public TideIdfileReader() {
    }

    public TideIdfileReader(File tideTsvFile) throws FileNotFoundException, IOException {
        this(tideTsvFile, null);
    }

    public TideIdfileReader(File tideTsvFile, WaitingHandler waitingHandler) throws IOException {
        this.tideTsvFile = tideTsvFile;
    }

    @Override
    public String getExtension() {
        return ".tide-search.target.txt";
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, true);
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        ArrayList<SpectrumMatch> result = new ArrayList<SpectrumMatch>();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.tideTsvFile);){
            String line;
            String headerString = reader.readLine();
            String[] headers = headerString.split("\t");
            int scanNumberIndex = -1;
            int chargeIndex = -1;
            int precursorMzIndex = -1;
            int spectrumNeutralLossIndex = -1;
            int peptideMassIndex = -1;
            int deltaCnIndex = -1;
            int spScoreIndex = -1;
            int spRankIndex = -1;
            int exactPValueIndex = -1;
            int xcorrScoreIndex = -1;
            int xcorrRank = -1;
            int bAndyIonsMatchedIndex = -1;
            int bAndyIonsTotal = -1;
            int distinctMatchesPerSpectrum = -1;
            int sequenceIndex = -1;
            int cleavageType = -1;
            int proteinId = -1;
            int flankingAa = -1;
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                if (header.equalsIgnoreCase("scan")) {
                    scanNumberIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("charge")) {
                    chargeIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("spectrum precursor m/z")) {
                    precursorMzIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("spectrum neutral mass")) {
                    spectrumNeutralLossIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("peptide mass")) {
                    peptideMassIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("delta_cn")) {
                    deltaCnIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("sp score")) {
                    spScoreIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("sp rank")) {
                    spRankIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("exact p-value")) {
                    exactPValueIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("xcorr score")) {
                    xcorrScoreIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("xcorr rank")) {
                    xcorrRank = i;
                    continue;
                }
                if (header.equalsIgnoreCase("b/y ions matched")) {
                    bAndyIonsMatchedIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("b/y ions total")) {
                    bAndyIonsTotal = i;
                    continue;
                }
                if (header.equalsIgnoreCase("distinct matches/spectrum")) {
                    distinctMatchesPerSpectrum = i;
                    continue;
                }
                if (header.equalsIgnoreCase("sequence")) {
                    sequenceIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("cleavage type")) {
                    cleavageType = i;
                    continue;
                }
                if (header.equalsIgnoreCase("protein id")) {
                    proteinId = i;
                    continue;
                }
                if (!header.equalsIgnoreCase("flanking aa")) continue;
                flankingAa = i;
            }
            if (scanNumberIndex == -1 || chargeIndex == -1 || xcorrRank == -1 || sequenceIndex == -1) {
                throw new IllegalArgumentException("Mandatory columns are missing in the Tide tsv file. Please check the file!");
            }
            String fileName = IoUtil.getFileName(this.tideTsvFile);
            String spectrumFileName = TideIdfileReader.getMgfFileName(fileName);
            HashMap<Long, SpectrumMatch> tempSpectrumMatchesMap = new HashMap<Long, SpectrumMatch>();
            while ((line = reader.readLine()) != null) {
                double rawScore;
                double tideEValue;
                String scoreAsText;
                String[] elements = line.split("\t");
                if (line.trim().isEmpty()) continue;
                int scanNumber = Integer.parseInt(elements[scanNumberIndex]);
                String modifiedPeptideSequence = elements[sequenceIndex].toUpperCase();
                int charge = Integer.parseInt(elements[chargeIndex]);
                int rank = xcorrRank != -1 ? Integer.parseInt(elements[xcorrRank]) : Integer.parseInt(elements[xcorrRank]);
                if (exactPValueIndex != -1) {
                    scoreAsText = elements[exactPValueIndex];
                    rawScore = tideEValue = Util.readDoubleAsString(scoreAsText);
                } else {
                    scoreAsText = elements[xcorrScoreIndex];
                    rawScore = Util.readDoubleAsString(scoreAsText);
                    tideEValue = rawScore < 0.0 ? 100.0 : Math.pow(10.0, -rawScore);
                }
                String spectrumTitle = spectrumProvider.getSpectrumTitles(IoUtil.removeExtension(spectrumFileName))[scanNumber];
                Long tempSpectrumMatchKey = ExperimentObject.asLong(String.join((CharSequence)"", spectrumFileName, spectrumTitle));
                SpectrumMatch currentMatch = (SpectrumMatch)tempSpectrumMatchesMap.get(tempSpectrumMatchKey);
                if (currentMatch == null) {
                    currentMatch = new SpectrumMatch(spectrumFileName, spectrumTitle);
                    tempSpectrumMatchesMap.put(tempSpectrumMatchKey, currentMatch);
                }
                ArrayList<ModificationMatch> utilitiesModifications = new ArrayList<ModificationMatch>();
                String unmodifiedPeptideSequence = "";
                if (modifiedPeptideSequence.contains("[")) {
                    for (int i = 0; i < modifiedPeptideSequence.length(); ++i) {
                        if (modifiedPeptideSequence.charAt(i) != '[') {
                            unmodifiedPeptideSequence = unmodifiedPeptideSequence + modifiedPeptideSequence.charAt(i);
                            continue;
                        }
                        char modifiedResidue = modifiedPeptideSequence.charAt(i - 1);
                        double ptmMass = Double.parseDouble(modifiedPeptideSequence.substring(i + 1, modifiedPeptideSequence.indexOf("]", i + 1)));
                        utilitiesModifications.add(new ModificationMatch(ptmMass + "@" + modifiedResidue, i));
                        i = modifiedPeptideSequence.indexOf("]", i + 1);
                    }
                } else {
                    unmodifiedPeptideSequence = modifiedPeptideSequence;
                }
                Peptide peptide = new Peptide(unmodifiedPeptideSequence, utilitiesModifications.toArray(new ModificationMatch[utilitiesModifications.size()]), true);
                PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, rank, Advocate.tide.getIndex(), charge, rawScore, tideEValue, IoUtil.getFileName(this.tideTsvFile));
                if (expandAaCombinations && AminoAcidSequence.hasCombination(unmodifiedPeptideSequence)) {
                    ModificationMatch[] previousModificationMatches = peptide.getVariableModifications();
                    for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                        ModificationMatch[] newModificationMatches = (ModificationMatch[])Arrays.stream(previousModificationMatches).map(modificationMatch -> modificationMatch.clone()).toArray(ModificationMatch[]::new);
                        Peptide newPeptide = new Peptide(expandedSequence.toString(), newModificationMatches, true);
                        PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getRawScore(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                        currentMatch.addPeptideAssumption(Advocate.tide.getIndex(), newAssumption);
                    }
                    continue;
                }
                currentMatch.addPeptideAssumption(Advocate.tide.getIndex(), peptideAssumption);
            }
            Iterator iterator = tempSpectrumMatchesMap.keySet().iterator();
            while (iterator.hasNext()) {
                result.add((SpectrumMatch)tempSpectrumMatchesMap.get(iterator.next()));
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.tideTsvFile = null;
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.softwareVersion);
        result.put("Tide", versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return false;
    }

    public static String getMgfFileName(String fileName) {
        if (fileName.endsWith(".tide-search.target.txt.gz")) {
            return fileName.substring(0, fileName.length() - 26) + ".mgf";
        }
        if (fileName.endsWith(".tide-search.target.txt")) {
            return fileName.substring(0, fileName.length() - 23) + ".mgf";
        }
        throw new IllegalArgumentException("Unexpected file extension. Expected: tide-search.target.txt or tide-search.target.txt.gz. File name: " + fileName + ".");
    }
}

