/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.mass_spectrometry.cms;

import com.compomics.util.experiment.io.mass_spectrometry.MsFileIterator;
import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFileReader;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;

public class CmsFileIterator
implements MsFileIterator {
    private final CmsFileReader reader;
    private final WaitingHandler waitingHandler;
    private int i = -1;

    public CmsFileIterator(File file, WaitingHandler waitingHandler) throws IOException {
        this.reader = new CmsFileReader(file, waitingHandler);
        this.waitingHandler = waitingHandler;
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(100);
    }

    @Override
    public String next() {
        ++this.i;
        double progress = 100.0 * (double)this.i / (double)this.reader.titles.length;
        this.waitingHandler.setSecondaryProgressCounter((int)progress);
        if (this.i == this.reader.titles.length) {
            return null;
        }
        return this.reader.titles[this.i];
    }

    @Override
    public Spectrum getSpectrum() {
        return this.reader.getSpectrum(this.reader.titles[this.i]);
    }

    @Override
    public void close() {
        this.waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        this.reader.close();
    }
}

