/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.mass_spectrometry.indexes;

import com.compomics.util.StreamUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.math.util.FastMath;

public class SpectrumIndex {
    private static final double MZ_ANCHOR = 1000.0;
    private static final double MZ_ANCHOR_LOG = FastMath.log((double)1000.0);
    private static final int[] EMPTY_ARRAY = new int[0];
    public final double tolerance;
    private boolean ppm;
    private final HashMap<Integer, ArrayList<Integer>> peaksMap = new HashMap();
    public final double[] mzArray;
    public final double[] intensityArray;
    private double scalingFactor;
    private Integer binMax;
    private Integer binMin;
    private double totalIntensity;
    public final double intensityLimit;

    public SpectrumIndex() {
        this.intensityLimit = 0.0;
        this.tolerance = 0.0;
        this.mzArray = null;
        this.intensityArray = null;
    }

    public SpectrumIndex(double[] mz, double[] intensity, double intensityLimit, double tolerance, boolean ppm) {
        this.intensityLimit = intensityLimit;
        this.mzArray = mz;
        this.intensityArray = intensity;
        this.tolerance = tolerance;
        this.ppm = ppm;
        if (ppm) {
            this.scalingFactor = FastMath.log((double)((1000000.0 - tolerance) / (1000000.0 + tolerance)));
        }
        this.totalIntensity = 0.0;
        for (int i = 0; i < mz.length; ++i) {
            ArrayList<Integer> indexes;
            double peakInt = intensity[i];
            if (!(peakInt >= intensityLimit)) continue;
            this.totalIntensity += peakInt;
            double peakMz = mz[i];
            int bin = this.getBin(peakMz);
            if (this.binMax == null || bin > this.binMax) {
                this.binMax = bin;
            }
            if (this.binMin == null || bin < this.binMin) {
                this.binMin = bin;
            }
            if ((indexes = this.peaksMap.get(bin)) == null) {
                indexes = new ArrayList(4);
                this.peaksMap.put(bin, indexes);
            }
            indexes.add(i);
        }
    }

    public HashMap<Integer, ArrayList<Integer>> getPeaksMap() {
        return this.peaksMap;
    }

    public boolean getPpm() {
        return this.ppm;
    }

    public double getPrecursorToleance() {
        return this.tolerance;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public int getBin(double mz) {
        return this.ppm ? this.getBinPpm(mz) : this.getBinAbsolute(mz);
    }

    private int getBinAbsolute(double mz) {
        int bin = (int)(mz / this.tolerance);
        return bin;
    }

    private int getBinPpm(double mz) {
        int bin = (int)((FastMath.log((double)mz) - MZ_ANCHOR_LOG) / this.scalingFactor);
        return bin;
    }

    public int[] getMatchingPeaks(double queryMz) {
        int bin0 = this.ppm ? this.getBinPpm(queryMz) : this.getBinAbsolute(queryMz);
        ArrayList<Integer> binContent1 = this.peaksMap.get(bin0 - 1);
        ArrayList<Integer> binContent2 = this.peaksMap.get(bin0);
        ArrayList<Integer> binContent3 = this.peaksMap.get(bin0 + 1);
        Stream<Integer> stream = StreamUtil.concatenate(binContent1, binContent2, binContent3);
        return stream == null ? EMPTY_ARRAY : stream.mapToInt(i -> i).filter(i -> this.isBelowTolerance(queryMz, i)).toArray();
    }

    private boolean isBelowTolerance(double queryMz, int index) {
        double peakMz = this.mzArray[index];
        double error = this.ppm ? 1000000.0 * (peakMz - queryMz) / queryMz : peakMz - queryMz;
        return Math.abs(error) <= this.tolerance;
    }

    public ArrayList<Integer> getBins() {
        return new ArrayList<Integer>(this.peaksMap.keySet());
    }

    public Set<Integer> getRawBins() {
        return this.peaksMap.keySet();
    }

    public ArrayList<Integer> getPeaksInBin(int bin) {
        return this.peaksMap.get(bin);
    }

    public double getMass(int bin) {
        return this.ppm ? FastMath.exp((double)(this.scalingFactor * (double)bin + MZ_ANCHOR_LOG)) : this.tolerance * (0.5 + (double)bin);
    }

    public Integer getBinMax() {
        return this.binMax;
    }

    public Integer getBinMin() {
        return this.binMin;
    }

    public double getTotalIntensity() {
        return this.totalIntensity;
    }

    public void setBinMax(Integer binMax) {
        this.binMax = binMax;
    }

    public void setBinMin(Integer binMin) {
        this.binMin = binMin;
    }

    public void setPpm(boolean ppm) {
        this.ppm = ppm;
    }

    public void setScalingFactor(double scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    public void setTotalIntensity(double totalIntensity) {
        this.totalIntensity = totalIntensity;
    }
}

