/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.mass_spectrometry.spectra;

import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.mass_spectrometry.SimpleNoiseDistribution;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.math.BasicMathFunctions;
import java.util.ArrayList;
import java.util.stream.IntStream;

public class SpectrumUtil {
    public static double getIntensityLimit(Spectrum spectrum, AnnotationParameters.IntensityThresholdType intensityThresholdType, double thresholdValue) {
        if (thresholdValue == 0.0) {
            return 0.0;
        }
        if (thresholdValue == 1.0) {
            return spectrum.getMaxIntensity();
        }
        switch (intensityThresholdType) {
            case snp: {
                SimpleNoiseDistribution tempBinnedCumulativeFunction = new SimpleNoiseDistribution(spectrum.intensity);
                return tempBinnedCumulativeFunction.getIntensityAtP(1.0 - thresholdValue);
            }
            case percentile: {
                return BasicMathFunctions.percentile(spectrum.intensity, thresholdValue);
            }
        }
        throw new UnsupportedOperationException("Threshold of type " + (Object)((Object)intensityThresholdType) + " not supported.");
    }

    public static double[][] getPeaksAboveIntensityThreshold(Spectrum spectrum, AnnotationParameters.IntensityThresholdType intensityThresholdType, double thresholdValue) {
        double intensityThreshold = SpectrumUtil.getIntensityLimit(spectrum, intensityThresholdType, thresholdValue);
        ArrayList<Integer> indexes = new ArrayList<Integer>(spectrum.getNPeaks() / 3);
        for (int i = 0; i < spectrum.getNPeaks(); ++i) {
            if (!(spectrum.intensity[i] > intensityThreshold)) continue;
            indexes.add(i);
        }
        double[][] result = new double[indexes.size()][2];
        for (int i = 0; i < indexes.size(); ++i) {
            int index = (Integer)indexes.get(i);
            result[i][0] = spectrum.mz[index];
            result[i][1] = spectrum.intensity[index];
        }
        return result;
    }

    public static int[] getWindowIndexes(Spectrum spectrum, double mzMin, double mzMax) {
        int windowStart = 0;
        for (int i = 0; i < spectrum.getNPeaks(); ++i) {
            double mz = spectrum.mz[i];
            if (mz >= mzMin && mz < mzMax) {
                if (windowStart != -1) continue;
                windowStart = i;
                continue;
            }
            if (!(mz >= mzMax)) continue;
            return new int[]{windowStart, i};
        }
        return new int[]{windowStart, spectrum.getNPeaks()};
    }

    public static int getNPeaksAboveThreshold(Spectrum spectrum, int startIndex, int endIndex, double intensityThreshold) {
        return (int)IntStream.range(startIndex, endIndex).mapToDouble(i -> spectrum.intensity[i]).filter(intensity -> intensity >= intensityThreshold).count();
    }
}

