/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.general;

import com.compomics.util.interfaces.SpectrumFile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Iterator;

public class IsotopicDistributionSpectrum
implements SpectrumFile {
    private int iCharge;
    private HashMap iPeaks = new HashMap();
    private double iPrecursorMZ;

    @Override
    public int getCharge() {
        return this.iCharge;
    }

    @Override
    public void setCharge(int aCharge) {
        this.iCharge = aCharge;
    }

    @Override
    public String getFilename() {
        return "Isotopic distribution";
    }

    @Override
    public void setFilename(String aFilename) {
    }

    public HashMap getPeaks() {
        return this.iPeaks;
    }

    @Override
    public void setPeaks(HashMap aPeaks) {
        this.iPeaks = aPeaks;
    }

    @Override
    public double getPrecursorMZ() {
        return this.iPrecursorMZ;
    }

    @Override
    public void setPrecursorMZ(double aPrecursorMZ) {
        this.iPrecursorMZ = aPrecursorMZ;
    }

    @Override
    public double getIntensity() {
        return 0.0;
    }

    @Override
    public void setIntensity(double aIntensity) {
    }

    @Override
    public double getTotalIntensity() {
        Iterator iter = this.iPeaks.values().iterator();
        double totalIntensity = 0.0;
        while (iter.hasNext()) {
            totalIntensity += ((Double)iter.next()).doubleValue();
        }
        return this.round(totalIntensity);
    }

    @Override
    public double getHighestIntensity() {
        Iterator iter = this.iPeaks.values().iterator();
        double highestIntensity = -1.0;
        while (iter.hasNext()) {
            double temp = (Double)iter.next();
            if (!(temp > highestIntensity)) continue;
            highestIntensity = temp;
        }
        return this.round(highestIntensity);
    }

    @Override
    public void writeToStream(OutputStream aOut) throws IOException {
    }

    @Override
    public void writeToFile(File aParentDir) throws IOException {
    }

    public int compareTo(Object o) {
        return 0;
    }

    private double round(double aTotalIntensity) {
        BigDecimal bd = new BigDecimal(aTotalIntensity).setScale(2, RoundingMode.UP);
        return bd.doubleValue();
    }
}

