/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.general.servlet;

import com.compomics.util.general.MassCalc;
import com.compomics.util.general.UnknownElementMassException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MassCalcServlet
extends HttpServlet {
    Logger logger = LogManager.getLogger(MassCalcServlet.class);
    private static final String SEQUENCE = "SEQUENCE";
    private static final String MASSLISTCHOICE = "MASSLISTCHOICE";
    private static final String MONOBIOCHEM = "MONOBIOCHEM";
    private static final String MONOAA = "MONOAA";
    private static final String SELFLIST = "SELFLIST";
    private static final String ADDSELFLISTBIOCHEM = "ADDSELFLISTBIOCHEM";
    private static final String ADDSELFLISTAA = "ADDSELFLISTAA";
    private static final String SELFDEFINEDLIST = "SELFDEFINEDLIST";
    private static final int NO_ERROR = 0;
    private static final int NO_SEQUENCE = 1;
    private static final int NO_SELFDEFINEDLIST = 2;
    private static final int WRONG_SELFDEFINEDLIST = 3;
    private static final int ONLY_SELF = 1;
    private static final int ADD_SELF = 2;

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) {
        block20: {
            try {
                if (req.getParameterNames().hasMoreElements()) {
                    String list;
                    Enumeration en = req.getParameterNames();
                    HashMap<String, String> params = new HashMap<String, String>(3);
                    while (en.hasMoreElements()) {
                        String key = (String)en.nextElement();
                        params.put(key, req.getParameter(key));
                    }
                    int selfDefined = 0;
                    HashMap selfList = null;
                    if (params.get(SEQUENCE) == null || ((String)params.get(SEQUENCE)).trim().equals("")) {
                        this.generateSubmissionForm(res, 1);
                        return;
                    }
                    if (params.get(MASSLISTCHOICE).equals(SELFLIST)) {
                        selfDefined = 1;
                        if (params.get(SELFDEFINEDLIST) == null || ((String)params.get(SELFDEFINEDLIST)).trim().equals("")) {
                            this.generateSubmissionForm(res, 2);
                            return;
                        }
                        list = (String)params.get(SELFDEFINEDLIST);
                        try {
                            selfList = this.parseSelfList(list);
                        }
                        catch (Exception e) {
                            this.generateSubmissionForm(res, 3);
                        }
                    } else if (params.get(MASSLISTCHOICE).equals(ADDSELFLISTBIOCHEM) || params.get(MASSLISTCHOICE).equals(ADDSELFLISTAA)) {
                        selfDefined = 2;
                        list = (String)params.get(SELFDEFINEDLIST);
                        try {
                            selfList = this.parseSelfList(list);
                        }
                        catch (Exception e) {
                            this.generateSubmissionForm(res, 3);
                        }
                    }
                    String sequence = (String)params.get(SEQUENCE);
                    int massList = 0;
                    if (selfDefined == 1) {
                        massList = -1;
                    } else {
                        String mlChoice = (String)params.get(MASSLISTCHOICE);
                        if ((mlChoice = mlChoice.trim()).equals(MONOBIOCHEM) || mlChoice.equals(ADDSELFLISTBIOCHEM)) {
                            massList = 0;
                        } else if (mlChoice.equals(MONOAA) || mlChoice.equals(ADDSELFLISTAA)) {
                            massList = 1;
                        }
                    }
                    double mass = 0.0;
                    MassCalc mc = null;
                    mc = massList >= 0 ? (selfDefined == 2 ? new MassCalc(massList, selfList) : new MassCalc(massList)) : new MassCalc(selfList);
                    try {
                        mass = mc.calculateMass(sequence);
                        this.writeOutput(res, sequence, mass);
                    }
                    catch (UnknownElementMassException uem) {
                        this.handleError(res, sequence, uem);
                    }
                    break block20;
                }
                this.generateSubmissionForm(res, 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void generateSubmissionForm(HttpServletResponse res, int error) throws IOException {
        PrintWriter out = res.getWriter();
        out.println("<html>");
        out.println("\t<head><title>Generic Mass Calculator (L. Martens)</title></head>");
        out.println("\t<body>");
        out.println("\t\t<h1>Generic mass calculator <i>(by Lennart Martens)</i></h1>");
        if (error != 0) {
            this.printErrorMessage(out, error);
        }
        out.println("\t\t<br /><hr /><br />");
        out.println("\t\t<form method=\"POST\" action=\"http://beo04.rug.ac.be/utilities/masscalc\">");
        out.println("\t\t\t<table>");
        out.println("\t\t\t\t<tr>");
        out.println("\t\t\t\t\t<td align=\"center\">");
        out.println("\t\t\t\t\t\t<h3>Paste your sequence here:</h3>");
        out.println("\t\t\t\t\t</td>");
        out.println("\t\t\t\t\t<td>");
        out.println("\t\t\t\t\t\t<h3>Paste your own masslist here (key=value)</h3>");
        out.println("\t\t\t\t\t</td>");
        out.println("\t\t\t\t</tr>");
        out.println("\t\t\t\t<tr>");
        out.println("\t\t\t\t\t<td align=\"center\" valign=\"top\">");
        out.println("\t\t\t\t\t\t<textarea name=\"SEQUENCE\" rows=\"6\" cols=\"40\"></textarea>");
        out.println("\t\t\t\t\t</td>");
        out.println("\t\t\t\t\t<td align=\"center\" valign=\"top\" rowspan=\"2\">");
        out.println("\t\t\t\t\t\t<textarea name=\"SELFDEFINEDLIST\" rows=\"12\" cols=\"30\"></textarea>");
        out.println("\t\t\t\t\t</td>");
        out.println("\t\t\t\t</tr>");
        out.println("\t\t\t\t<tr>");
        out.println("\t\t\t\t\t<td>");
        out.println("\t\t\t\t\t\t<br />");
        out.println("\t\t\t\t\t\t<input type=\"radio\" name=\"MASSLISTCHOICE\" value=\"MONOBIOCHEM\" checked/> <b>Monoisotopic biochemical elements</b>");
        out.println("\t\t\t\t\t\t<br />");
        out.println("\t\t\t\t\t\t<input type=\"radio\" name=\"MASSLISTCHOICE\" value=\"MONOAA\" /> <b>Monoisotopic amino acids</b>");
        out.println("\t\t\t\t\t\t<br />");
        out.println("\t\t\t\t\t\t<input type=\"radio\" name=\"MASSLISTCHOICE\" value=\"SELFLIST\" /> <b>Self-defined list</b>");
        out.println("\t\t\t\t\t\t<br />");
        out.println("\t\t\t\t\t\t<input type=\"radio\" name=\"MASSLISTCHOICE\" value=\"ADDSELFLISTBIOCHEM\" /> <b>Add/override self-defined elements to biochem list</b>");
        out.println("\t\t\t\t\t\t<br />");
        out.println("\t\t\t\t\t\t<input type=\"radio\" name=\"MASSLISTCHOICE\" value=\"ADDSELFLISTAA\" /> <b>Add/override self-defined elements to AA list</b>");
        out.println("\t\t\t\t\t\t<br />");
        out.println("\t\t\t\t\t</td>");
        out.println("\t\t\t\t</tr>");
        out.println("\t\t\t</table>");
        out.println("\t\t\t<br /><br /><br /><br />");
        out.println("\t\t\t<input type=\"submit\" value=\"Calculate!\" />");
        out.println("\t\t\t<br />");
        out.println("\t\t\t<input type=\"reset\" value=\"Reset form.\" />");
        out.println("\t\t</form>");
        out.println("</body>");
        out.println("</html>");
        out.flush();
        out.close();
    }

    private void printErrorMessage(PrintWriter out, int aErrorCode) {
        switch (aErrorCode) {
            case 0: {
                break;
            }
            case 1: {
                out.println("\t\t<font color=\"red\"><h1>You need to enter a sequence!</h1></font>");
                break;
            }
            case 2: {
                out.println("\t\t<font color=\"red\"><h1>If you select the 'Self defined list' choice, you need to specify a list in the text area on the right!</h1></font>");
                out.println("\t\t<br /><br />");
                break;
            }
            case 3: {
                out.println("\t\t<font color=\"red\"><h1>Your self-defined list cannot be parsed! It should be formatted in KEY=VALUE pairs, KEY being a symbol of maximum two characters, the first character must be uppercase, the (optional) second character lowercase, and VALUE should hold a number. Only one KEY=VALUE pair per line!!!</h1></font>");
                out.println("\t\t<br /><br />");
            }
        }
    }

    private void writeOutput(HttpServletResponse aRes, String aSequence, double aMass) throws IOException {
        PrintWriter out = aRes.getWriter();
        out.println("<html>");
        out.println("\t<head><title>Mass for " + aSequence + "</title></head>");
        out.println("\t<body>");
        out.println("\t\t<h1>Mass calculation results</h1>");
        out.println("\t\t<hr /><br /><br /><br />");
        out.println("\t\t<h3>Mass was: <font color=\"blue\">" + aMass + "</font> Da.</h3>");
        out.println("\t\t<br /><br />");
        out.println("\t\t<h4>Sequence was:<h4>");
        out.println("\t\t<font color=\"green\">" + aSequence + "</font>");
        out.println("\t</body>");
        out.println("</html>");
        out.flush();
        out.close();
    }

    private void handleError(HttpServletResponse aRes, String aSequence, UnknownElementMassException aUem) throws IOException {
        PrintWriter out = aRes.getWriter();
        out.println("<html>");
        out.println("\t<head><title>Unknown element '" + aUem.getElement() + "' encountered!</title></head>");
        out.println("\t<body>");
        out.println("\t\t<font color=\"red\"><h1>Unknown element '" + aUem.getElement() + "' encountered!</h1></font>");
        out.println("\t\tDid you type the case correctly according to IUPAC standards? <br />");
        out.println("\t\tDid you type amino acid one letter code and in UPPERCASE?");
        out.println("\t\t<br /><br /><hr /><br /><br />");
        aUem.printStackTrace(out);
        out.println("\t</body>");
        out.println("</html>");
        out.flush();
        out.close();
    }

    private HashMap parseSelfList(String aList) throws Exception {
        HashMap<String, Double> toReturn = new HashMap<String, Double>();
        aList = aList.trim();
        StringTokenizer st = new StringTokenizer(aList, " =_:\n");
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            Double value = Double.valueOf(st.nextToken());
            toReturn.put(key, value);
        }
        return toReturn;
    }
}

