/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import com.compomics.util.gui.CheckBoxCellRenderer;
import com.compomics.util.gui.CheckableItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicComboPopup;

public class CheckedComboBox<E extends CheckableItem>
extends JComboBox<E> {
    private boolean keepOpen;
    private transient ActionListener listener;

    public CheckedComboBox() {
    }

    public CheckedComboBox(ComboBoxModel<E> aModel) {
        super(aModel);
    }

    public CheckedComboBox(E[] m) {
        super(m);
    }

    @Override
    public void updateUI() {
        this.setRenderer(null);
        this.removeActionListener(this.listener);
        super.updateUI();
        this.listener = e -> {
            if (e.getModifiers() == 16) {
                this.updateItem(this.getSelectedIndex());
                this.keepOpen = true;
            }
        };
        this.setRenderer(new CheckBoxCellRenderer());
        this.addActionListener(this.listener);
        this.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), "checkbox-select");
        this.getActionMap().put("checkbox-select", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Accessible a = CheckedComboBox.this.getAccessibleContext().getAccessibleChild(0);
                if (a instanceof BasicComboPopup) {
                    BasicComboPopup pop = (BasicComboPopup)a;
                    CheckedComboBox.this.updateItem(pop.getList().getSelectedIndex());
                }
            }
        });
    }

    private void updateItem(int index) {
        if (this.isPopupVisible()) {
            CheckableItem item = (CheckableItem)this.getItemAt(index);
            item.selected ^= true;
            this.removeItemAt(index);
            this.insertItemAt(item, index);
            this.setSelectedItem(item);
        }
    }

    @Override
    public void setPopupVisible(boolean v) {
        if (this.keepOpen) {
            this.keepOpen = false;
        } else {
            super.setPopupVisible(v);
        }
    }
}

