/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JFrameForBytes
extends JFrame {
    Logger logger = LogManager.getLogger(JFrameForBytes.class);
    private byte[] iData = null;
    private JTextArea txtData = null;
    private JButton btnUnzip = null;
    private JButton btnSave = null;

    public JFrameForBytes(String aTitle, byte[] aData) {
        super(aTitle);
        this.iData = aData;
        if (this.iData == null) {
            this.iData = "<null>".getBytes();
        }
        this.constructScreen();
        this.pack();
    }

    private void constructScreen() {
        this.txtData = new JTextArea(10, 40);
        this.txtData.setFont(new Font("Monospaced", 0, 12));
        JScrollPane scroll = new JScrollPane(this.txtData);
        try {
            this.txtData.setText(new String(this.iData, "UTF-8"));
            if (this.iData.length > 0) {
                this.txtData.setCaretPosition(1);
            }
        }
        catch (UnsupportedEncodingException usee) {
            this.txtData.setText("Data could not be converted to ASCII text...");
        }
        this.btnUnzip = new JButton("Unzip data");
        this.btnUnzip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrameForBytes.this.unzipPressed();
            }
        });
        this.btnSave = new JButton("Save to file...");
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrameForBytes.this.savePressed();
            }
        });
        JPanel jpanButton = new JPanel();
        jpanButton.setLayout(new BoxLayout(jpanButton, 0));
        jpanButton.add(Box.createHorizontalGlue());
        jpanButton.add(this.btnSave);
        jpanButton.add(Box.createRigidArea(new Dimension(5, this.btnUnzip.getHeight())));
        jpanButton.add(this.btnUnzip);
        jpanButton.add(Box.createRigidArea(new Dimension(5, this.btnUnzip.getHeight())));
        JPanel jpanMain = new JPanel(new BorderLayout());
        jpanMain.add((Component)scroll, "Center");
        jpanMain.add((Component)jpanButton, "South");
        this.getContentPane().add((Component)jpanMain, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                e.getWindow().setVisible(false);
                e.getWindow().dispose();
            }
        });
    }

    private void unzipPressed() {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.iData);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            try {
                ZipInputStream zis = new ZipInputStream(bais);
                ZipEntry ze = null;
                boolean atLeastOnce = false;
                while ((ze = zis.getNextEntry()) != null) {
                    atLeastOnce = true;
                    String name = ze.getName();
                    String spacer = "";
                    int length = name.length();
                    for (int i = 0; i < length; ++i) {
                        spacer = spacer + "-";
                    }
                    bos.write((spacer + "\n" + name + "\n" + spacer + "\n").getBytes("ASCII"));
                    int lData = -1;
                    while ((lData = zis.read()) != -1) {
                        bos.write(lData);
                    }
                    bos.write("\n".getBytes("ASCII"));
                }
                zis.close();
                if (!atLeastOnce) {
                    throw new ZipException("Not a zip stream.");
                }
            }
            catch (ZipException ze) {
                bais = new ByteArrayInputStream(this.iData);
                GZIPInputStream gi = new GZIPInputStream(bais);
                int lData = -1;
                while ((lData = gi.read()) != -1) {
                    bos.write(lData);
                }
                gi.close();
            }
            bais.close();
            bos.flush();
            baos.flush();
            this.iData = baos.toByteArray();
            this.txtData.setText(new String(this.iData));
            if (this.txtData.getText().length() > 0) {
                this.txtData.setCaretPosition(1);
            }
            bos.close();
            baos.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, new String[]{"Unable to unzip data!", "Is this data zipped?"}, "Error unzipping data", 0);
        }
    }

    private void savePressed() {
        String text = this.txtData.getText();
        try {
            FileDialog fd = new FileDialog((Frame)this, "Save contents of frame to disk...", 1);
            fd.setVisible(true);
            String select = fd.getFile();
            if (select == null) {
                return;
            }
            select = fd.getDirectory() + select;
            File output = new File(select);
            if (!output.exists()) {
                output.createNewFile();
            }
            BufferedReader br = new BufferedReader(new StringReader(text));
            BufferedWriter bw = new BufferedWriter(new FileWriter(output));
            String line = null;
            while ((line = br.readLine()) != null) {
                bw.write(line + "\n");
            }
            bw.flush();
            bw.close();
            br.close();
            JOptionPane.showMessageDialog(this, "Output written to " + select + ".", "Output written!", 1);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Unable to save data to file: " + ioe.getMessage(), "Unable to write data to file!", 0);
        }
    }
}

