/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.parameters.UtilitiesUserParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class PrivacyParametersDialog
extends JDialog {
    private Image normalIcon;
    private UtilitiesUserParameters utilitiesUserParameters;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel confidentialLabel;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JPanel settingsPanel;
    private JCheckBox updatesCheck;

    public PrivacyParametersDialog(Frame parent, Image normalIcon) {
        super(parent, true);
        this.initComponents();
        this.loadPreferencesOnGUI();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void loadPreferencesOnGUI() {
        try {
            this.utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "An error occurred while loading the user preferences.", "User Preferences Error", 2);
            e.printStackTrace();
            this.utilitiesUserParameters = new UtilitiesUserParameters();
        }
        this.updatesCheck.setSelected(this.utilitiesUserParameters.isAutoUpdate());
    }

    private void savePreferences() {
        this.utilitiesUserParameters.setAutoUpdate(this.updatesCheck.isSelected());
        try {
            UtilitiesUserParameters.saveUserParameters(this.utilitiesUserParameters);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "An error occurred while saving the user preferences.", "User Preferences Error", 2);
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.settingsPanel = new JPanel();
        this.updatesCheck = new JCheckBox();
        this.confidentialLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Privacy Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrivacyParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrivacyParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PrivacyParametersDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrivacyParametersDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrivacyParametersDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder("Options (all CompOmics tools)"));
        this.settingsPanel.setOpaque(false);
        this.updatesCheck.setText("Check for Updates at Tool Startup");
        this.updatesCheck.setIconTextGap(15);
        this.updatesCheck.setOpaque(false);
        GroupLayout settingsPanelLayout = new GroupLayout(this.settingsPanel);
        this.settingsPanel.setLayout(settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.updatesCheck).addContainerGap(188, Short.MAX_VALUE)));
        settingsPanelLayout.setVerticalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.updatesCheck).addContainerGap(-1, Short.MAX_VALUE)));
        this.confidentialLabel.setFont(new Font("Tahoma", 2, 11));
        this.confidentialLabel.setText("The information is handled confidentially.");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.settingsPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.confidentialLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.settingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.openDialogHelpJButton).addComponent(this.confidentialLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/PrivacySettingsHelp.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), this.normalIcon, "Privacy Settings - Help", 500, 100);
        this.setCursor(new Cursor(0));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.savePreferences();
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

