/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import com.compomics.util.gui.XYPlottingDialog;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class XYPlotFiltersDialog
extends JDialog {
    private final XYPlottingDialog xyPlottingDialog;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel filterTypesLabel;
    private JScrollPane filtersScrollPane;
    private JTable filtersTable;
    private JButton okButton;

    public XYPlotFiltersDialog(XYPlottingDialog xyPlottingDialog, boolean modal) {
        super((Dialog)xyPlottingDialog, modal);
        this.initComponents();
        this.xyPlottingDialog = xyPlottingDialog;
        this.setUpGUI();
        this.insertData();
        this.setLocationRelativeTo(xyPlottingDialog);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.filtersTable.getTableHeader().setReorderingAllowed(false);
        JPanel proteinCorner = new JPanel();
        proteinCorner.setBackground(this.filtersTable.getTableHeader().getBackground());
        this.filtersScrollPane.setCorner("UPPER_RIGHT_CORNER", proteinCorner);
        this.filtersScrollPane.getViewport().setOpaque(false);
        this.filtersTable.getColumn(" ").setMaxWidth(50);
        this.filtersTable.getColumn(" ").setMinWidth(50);
    }

    private void insertData() {
        Vector<String> columnNames = this.xyPlottingDialog.getColummnNames();
        HashMap<String, String> dataFiltersInclude = this.xyPlottingDialog.getDataFilters();
        for (String columnName : columnNames) {
            ((DefaultTableModel)this.filtersTable.getModel()).addRow(new Object[]{this.filtersTable.getRowCount() + 1, columnName, dataFiltersInclude.get(columnName)});
        }
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.filtersScrollPane = new JScrollPane();
        this.filtersTable = new JTable();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.filterTypesLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Data Filters");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.filtersTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Column", "Include"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.filtersScrollPane.setViewportView(this.filtersTable);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlotFiltersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XYPlotFiltersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.filterTypesLabel.setFont(this.filterTypesLabel.getFont().deriveFont(this.filterTypesLabel.getFont().getStyle() | 2));
        this.filterTypesLabel.setText("Supported filter types: >number, =number, <number, =text.");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filtersScrollPane, -1, 628, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.filterTypesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.filtersScrollPane, -1, 295, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.filterTypesLabel)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        HashMap<String, String> dataFiltersInclude = new HashMap<String, String>();
        for (int i = 0; i < this.filtersTable.getRowCount(); ++i) {
            String dataFilter = null;
            if (this.filtersTable.getValueAt(i, 2) != null && (dataFilter = ((String)this.filtersTable.getValueAt(i, 2)).trim()).length() > 0) {
                if (dataFilter.startsWith(">") || dataFilter.startsWith("=") || dataFilter.startsWith("<")) {
                    if (dataFilter.length() == 1) {
                        JOptionPane.showMessageDialog(this, "One of the filters '" + dataFilter + "' seems to be empty.", "Filter Error", 1);
                        return;
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "The filters have to start with >,= or <.", "Filter Error", 1);
                    return;
                }
            }
            dataFiltersInclude.put((String)this.filtersTable.getValueAt(i, 1), dataFilter);
        }
        this.xyPlottingDialog.setDataFilters(dataFiltersInclude);
        this.xyPlottingDialog.updatePlot();
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

