/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.atoms;

import com.compomics.util.experiment.biology.atoms.Atom;
import com.compomics.util.experiment.biology.atoms.AtomChain;
import com.compomics.util.experiment.biology.atoms.AtomImpl;
import com.compomics.util.gui.atoms.AtomPanel;
import com.compomics.util.gui.error_handlers.HelpDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import no.uib.jsparklines.renderers.util.Util;

public class AtomChainDialog
extends JDialog {
    private AtomChain atomChainAdded;
    private AtomChain atomChainRemoved;
    private boolean canceled = false;
    private int atomPanelIndex = 0;
    private boolean settingUpGUI = false;
    private boolean addOnly;
    private JLabel MassLbl;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel compositionLbl;
    private JPanel compositionPanel;
    private JTextField compositionTxt;
    private JPanel editPanel;
    private JPanel elementsPanel;
    private JScrollPane elementsScrollPane;
    private JButton helpJButton;
    private JTextField massTxt;
    private JButton okButton;

    public AtomChainDialog(JDialog parent, AtomChain atomChainAdded, AtomChain atomChainRemoved, boolean onlyAddition) {
        super((Dialog)parent, true);
        this.initComponents();
        this.atomChainAdded = atomChainAdded != null ? atomChainAdded.clone() : new AtomChain();
        this.atomChainRemoved = atomChainRemoved != null ? atomChainRemoved.clone() : new AtomChain();
        this.addOnly = onlyAddition;
        this.setupGUI();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public AtomChainDialog(Frame parent, AtomChain atomChainAdded, AtomChain atomChainRemoved, boolean onlyAddition) {
        super(parent, true);
        this.initComponents();
        this.atomChainAdded = atomChainAdded != null ? atomChainAdded.clone() : new AtomChain();
        this.atomChainRemoved = atomChainRemoved != null ? atomChainRemoved.clone() : new AtomChain();
        this.addOnly = onlyAddition;
        this.setupGUI();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setupGUI() {
        HashSet isotopeList;
        Atom atom;
        String atomSymbol;
        this.elementsScrollPane.getViewport().setOpaque(false);
        this.settingUpGUI = true;
        if (this.atomChainAdded.getAtomChain().isEmpty() && this.atomChainRemoved.getAtomChain().isEmpty()) {
            this.elementsPanel.add(new AtomPanel(this, null, 0, 0, this.atomPanelIndex++, this.addOnly));
        }
        if (!this.atomChainAdded.getAtomChain().isEmpty()) {
            HashMap atomsAdded = new HashMap(4);
            for (AtomImpl tempAtomImpl : this.atomChainAdded.getAtomChain()) {
                atomSymbol = tempAtomImpl.getAtomSymbol();
                atom = Atom.getAtom(atomSymbol);
                isotopeList = (HashSet)atomsAdded.get(atomSymbol);
                if (isotopeList == null) {
                    this.elementsPanel.add(new AtomPanel(this, atom, tempAtomImpl.getIsotope(), this.atomChainAdded.getOccurrence(atom, tempAtomImpl.getIsotope()), this.atomPanelIndex++, this.addOnly));
                    isotopeList = new HashSet(2);
                    isotopeList.add(tempAtomImpl.getIsotope());
                    atomsAdded.put(atomSymbol, isotopeList);
                    continue;
                }
                if (isotopeList.contains(tempAtomImpl.getIsotope())) continue;
                this.elementsPanel.add(new AtomPanel(this, atom, tempAtomImpl.getIsotope(), this.atomChainAdded.getOccurrence(atom, tempAtomImpl.getIsotope()), this.atomPanelIndex++, this.addOnly));
                isotopeList.add(tempAtomImpl.getIsotope());
            }
        }
        if (!this.atomChainRemoved.getAtomChain().isEmpty()) {
            HashMap atomsRemoved = new HashMap(4);
            for (AtomImpl tempAtomImpl : this.atomChainRemoved.getAtomChain()) {
                atomSymbol = tempAtomImpl.getAtomSymbol();
                atom = Atom.getAtom(atomSymbol);
                isotopeList = (HashSet)atomsRemoved.get(atomSymbol);
                if (isotopeList == null) {
                    this.elementsPanel.add(new AtomPanel(this, atom, tempAtomImpl.getIsotope(), -this.atomChainRemoved.getOccurrence(atom, tempAtomImpl.getIsotope()), this.atomPanelIndex++, this.addOnly));
                    isotopeList = new HashSet(2);
                    isotopeList.add(tempAtomImpl.getIsotope());
                    atomsRemoved.put(atomSymbol, isotopeList);
                    continue;
                }
                if (isotopeList.contains(tempAtomImpl.getIsotope())) continue;
                this.elementsPanel.add(new AtomPanel(this, atom, tempAtomImpl.getIsotope(), -this.atomChainRemoved.getOccurrence(atom, tempAtomImpl.getIsotope()), this.atomPanelIndex++, this.addOnly));
                isotopeList.add(tempAtomImpl.getIsotope());
            }
        }
        this.settingUpGUI = false;
        this.updateAtomComposition();
        this.elementsPanel.revalidate();
        this.elementsPanel.repaint();
    }

    public void addElementsPanel() {
        this.elementsPanel.add(new AtomPanel(this, null, 0, 0, this.atomPanelIndex++, this.addOnly));
    }

    public void removeElementsPanel(int panelIndex) {
        for (int componentIndex = 0; componentIndex < this.elementsPanel.getComponentCount(); ++componentIndex) {
            AtomPanel tempAtomPanel;
            Component tempComponent = this.elementsPanel.getComponent(componentIndex);
            if (!(tempComponent instanceof AtomPanel) || (tempAtomPanel = (AtomPanel)tempComponent).getPanelIndex() != panelIndex) continue;
            this.elementsPanel.remove(componentIndex);
            break;
        }
        this.updateAtomComposition();
        if (this.elementsPanel.getComponents().length == 0) {
            this.addElementsPanel();
        }
        this.elementsPanel.revalidate();
        this.elementsPanel.repaint();
    }

    public void updateAtomComposition() {
        if (!this.settingUpGUI) {
            this.atomChainAdded = new AtomChain();
            this.atomChainRemoved = new AtomChain();
            for (int componentIndex = 0; componentIndex < this.elementsPanel.getComponentCount(); ++componentIndex) {
                int previousOccurence;
                AtomPanel tempAtomPanel;
                Component tempComponent = this.elementsPanel.getComponent(componentIndex);
                if (!(tempComponent instanceof AtomPanel) || (tempAtomPanel = (AtomPanel)tempComponent).getAtom() == null || tempAtomPanel.getIsotope() == null || tempAtomPanel.getOccurrence() == 0) continue;
                if (tempAtomPanel.getOccurrence() > 0) {
                    previousOccurence = this.atomChainAdded.getOccurrence(tempAtomPanel.getAtom(), tempAtomPanel.getIsotope());
                    this.atomChainAdded.setOccurrence(tempAtomPanel.getAtom(), tempAtomPanel.getIsotope(), previousOccurence + tempAtomPanel.getOccurrence());
                    continue;
                }
                previousOccurence = this.atomChainRemoved.getOccurrence(tempAtomPanel.getAtom(), tempAtomPanel.getIsotope());
                this.atomChainRemoved.setOccurrence(tempAtomPanel.getAtom(), tempAtomPanel.getIsotope(), previousOccurence + Math.abs(tempAtomPanel.getOccurrence()));
            }
            String addition = "";
            if (this.atomChainAdded.size() > 0) {
                addition = this.atomChainAdded.toString();
            }
            String deletion = "";
            if (this.atomChainRemoved.size() > 0) {
                deletion = "-" + this.atomChainRemoved.toString();
            }
            String temp = addition + " " + deletion;
            this.compositionTxt.setText(temp.trim());
            this.massTxt.setText(Util.roundDouble((double)(this.atomChainAdded.getMass() - this.atomChainRemoved.getMass()), (int)6) + " Da");
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public AtomChain getAtomChainAdded() {
        return this.atomChainAdded;
    }

    public AtomChain getAtomChainRemoved() {
        return this.atomChainRemoved;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AtomChainDialog dialog = new AtomChainDialog((Frame)new JFrame(), new AtomChain(), new AtomChain(), false);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.editPanel = new JPanel();
        this.elementsScrollPane = new JScrollPane();
        this.elementsPanel = new JPanel();
        this.compositionPanel = new JPanel();
        this.compositionLbl = new JLabel();
        this.compositionTxt = new JTextField();
        this.MassLbl = new JLabel();
        this.massTxt = new JTextField();
        this.helpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Atomic Composition");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AtomChainDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AtomChainDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.editPanel.setBorder(BorderFactory.createTitledBorder("Composition Editor"));
        this.editPanel.setOpaque(false);
        this.elementsScrollPane.setBorder(null);
        this.elementsScrollPane.setHorizontalScrollBarPolicy(31);
        this.elementsScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.elementsScrollPane.setOpaque(false);
        this.elementsPanel.setOpaque(false);
        this.elementsPanel.setLayout(new BoxLayout(this.elementsPanel, 1));
        this.elementsScrollPane.setViewportView(this.elementsPanel);
        GroupLayout editPanelLayout = new GroupLayout(this.editPanel);
        this.editPanel.setLayout(editPanelLayout);
        editPanelLayout.setHorizontalGroup(editPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.elementsScrollPane).addContainerGap()));
        editPanelLayout.setVerticalGroup(editPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, editPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.elementsScrollPane, -1, 262, Short.MAX_VALUE).addContainerGap()));
        this.compositionPanel.setBorder(BorderFactory.createTitledBorder("Atomic Composition"));
        this.compositionPanel.setOpaque(false);
        this.compositionLbl.setText("Composition");
        this.compositionTxt.setEditable(false);
        this.compositionTxt.setHorizontalAlignment(0);
        this.MassLbl.setText("Mass");
        this.massTxt.setEditable(false);
        this.massTxt.setHorizontalAlignment(0);
        GroupLayout compositionPanelLayout = new GroupLayout(this.compositionPanel);
        this.compositionPanel.setLayout(compositionPanelLayout);
        compositionPanelLayout.setHorizontalGroup(compositionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(compositionPanelLayout.createSequentialGroup().addContainerGap().addGroup(compositionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.compositionLbl).addComponent(this.MassLbl)).addGap(18, 18, 18).addGroup(compositionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.compositionTxt).addComponent(this.massTxt)).addContainerGap()));
        compositionPanelLayout.setVerticalGroup(compositionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(compositionPanelLayout.createSequentialGroup().addContainerGap().addGroup(compositionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.compositionLbl).addComponent(this.compositionTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(compositionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.MassLbl).addComponent(this.massTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                AtomChainDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AtomChainDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AtomChainDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.compositionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.editPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 398, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.compositionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addComponent(this.helpJButton, -2, 23, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/AtomChainDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Atom Composition - Help", 500, 10);
        this.setCursor(new Cursor(0));
    }
}

