/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.enzymes;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.gui.enzymes.NewEnzymeDialog;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.pride.CvTerm;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.HtmlLinksRenderer;

public class EnzymesDialog
extends JDialog {
    private EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
    private ArrayList<String> defaultEnzymesTableToolTips;
    private ArrayList<String> userEnzymesTableToolTips;
    private final String selectedRowHtmlTagFontColor = "#FFFFFF";
    private final String notSelectedRowHtmlTagFontColor = "#0101DF";
    private JButton addUserEnzyme;
    private JButton deleteEnzymeButton;
    private JPanel enzymesEditorPanel;
    private JButton enzymesHelpJButton;
    private JPanel enzymesPanel;
    private JScrollPane enzymesScrollPane;
    private JTable enzymesTable;
    private JLabel exportEnzymesLabel;
    private JLabel importEnzymesLabel;
    private JButton okButton;
    private JLabel resetEnzymesLabel;

    public EnzymesDialog(Frame parentFrame, boolean modal) {
        super(parentFrame, modal);
        this.initComponents();
        this.setUpTables();
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    private void setUpTables() {
        this.enzymesTable.setAutoCreateRowSorter(true);
        this.enzymesScrollPane.getViewport().setOpaque(false);
        this.enzymesTable.getTableHeader().setReorderingAllowed(false);
        this.enzymesTable.getColumn(" ").setMaxWidth(40);
        this.enzymesTable.getColumn(" ").setMinWidth(40);
        this.enzymesTable.getColumn("PSI-MOD").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer("#FFFFFF", "#0101DF"));
        this.defaultEnzymesTableToolTips = new ArrayList();
        this.defaultEnzymesTableToolTips.add(null);
        this.defaultEnzymesTableToolTips.add("Name");
        this.defaultEnzymesTableToolTips.add("Cleaves After");
        this.defaultEnzymesTableToolTips.add("Does Not Cleave If Follow By");
        this.defaultEnzymesTableToolTips.add("Cleaves Before");
        this.defaultEnzymesTableToolTips.add("Does Not Cleave If Preceeded By");
        this.defaultEnzymesTableToolTips.add("PSI-MOD Mapping");
        this.userEnzymesTableToolTips = new ArrayList();
        this.userEnzymesTableToolTips.add(null);
        this.userEnzymesTableToolTips.add("Name");
        this.userEnzymesTableToolTips.add("Cleaves After");
        this.userEnzymesTableToolTips.add("Does Not Cleave If Follow By");
        this.userEnzymesTableToolTips.add("Cleaves Before");
        this.userEnzymesTableToolTips.add("Does Not Cleave If Preceeded By");
        this.userEnzymesTableToolTips.add("PSI-MOD Mapping");
        ((TitledBorder)this.enzymesPanel.getBorder()).setTitle("Enzymes (" + this.enzymesTable.getRowCount() + ")");
    }

    private void initComponents() {
        this.enzymesEditorPanel = new JPanel();
        this.enzymesPanel = new JPanel();
        this.enzymesScrollPane = new JScrollPane();
        this.enzymesTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)EnzymesDialog.this.defaultEnzymesTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.exportEnzymesLabel = new JLabel();
        this.addUserEnzyme = new JButton();
        this.deleteEnzymeButton = new JButton();
        this.resetEnzymesLabel = new JLabel();
        this.importEnzymesLabel = new JLabel();
        this.okButton = new JButton();
        this.enzymesHelpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Enzyme Details");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EnzymesDialog.this.formWindowClosing(evt);
            }
        });
        this.enzymesEditorPanel.setBackground(new Color(230, 230, 230));
        this.enzymesPanel.setBorder(BorderFactory.createTitledBorder("Enzymes"));
        this.enzymesPanel.setOpaque(false);
        this.enzymesTable.setModel(new DefaultEnzymesTable());
        this.enzymesTable.setSelectionMode(0);
        this.enzymesTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                EnzymesDialog.this.enzymesTableMouseMoved(evt);
            }
        });
        this.enzymesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EnzymesDialog.this.enzymesTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                EnzymesDialog.this.enzymesTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                EnzymesDialog.this.enzymesTableMouseReleased(evt);
            }
        });
        this.enzymesScrollPane.setViewportView(this.enzymesTable);
        this.exportEnzymesLabel.setText("<html><a href>Export to file</a></html>");
        this.exportEnzymesLabel.setToolTipText("Export to enzymes factory file");
        this.exportEnzymesLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                EnzymesDialog.this.exportEnzymesLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                EnzymesDialog.this.exportEnzymesLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                EnzymesDialog.this.exportEnzymesLabelMouseReleased(evt);
            }
        });
        this.addUserEnzyme.setText("Add");
        this.addUserEnzyme.setToolTipText("Add a new enzyme");
        this.addUserEnzyme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnzymesDialog.this.addUserEnzymeActionPerformed(evt);
            }
        });
        this.deleteEnzymeButton.setText("Delete");
        this.deleteEnzymeButton.setToolTipText("Delete an enzyme");
        this.deleteEnzymeButton.setEnabled(false);
        this.deleteEnzymeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnzymesDialog.this.deleteEnzymeButtonActionPerformed(evt);
            }
        });
        this.resetEnzymesLabel.setText("<html><a href>Reset to default</a></html>");
        this.resetEnzymesLabel.setToolTipText("Reset to the default list of enzymes");
        this.resetEnzymesLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                EnzymesDialog.this.resetEnzymesLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                EnzymesDialog.this.resetEnzymesLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                EnzymesDialog.this.resetEnzymesLabelMouseReleased(evt);
            }
        });
        this.importEnzymesLabel.setText("<html><a href>Import from file</a></html>");
        this.importEnzymesLabel.setToolTipText("Import from enzymes factory file");
        this.importEnzymesLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                EnzymesDialog.this.importEnzymesLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                EnzymesDialog.this.importEnzymesLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                EnzymesDialog.this.importEnzymesLabelMouseReleased(evt);
            }
        });
        GroupLayout enzymesPanelLayout = new GroupLayout(this.enzymesPanel);
        this.enzymesPanel.setLayout(enzymesPanelLayout);
        enzymesPanelLayout.setHorizontalGroup(enzymesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, enzymesPanelLayout.createSequentialGroup().addContainerGap().addGroup(enzymesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.enzymesScrollPane, -1, 738, Short.MAX_VALUE).addGroup(enzymesPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.exportEnzymesLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.importEnzymesLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.resetEnzymesLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 353, Short.MAX_VALUE).addComponent(this.addUserEnzyme, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteEnzymeButton, -2, 65, -2))).addContainerGap()));
        enzymesPanelLayout.setVerticalGroup(enzymesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, enzymesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.enzymesScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(enzymesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(enzymesPanelLayout.createSequentialGroup().addGroup(enzymesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportEnzymesLabel, -2, -1, -2).addComponent(this.resetEnzymesLabel, -2, -1, -2).addComponent(this.importEnzymesLabel, -2, -1, -2)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, enzymesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteEnzymeButton).addComponent(this.addUserEnzyme, -1, -1, Short.MAX_VALUE)))));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnzymesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.enzymesHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.enzymesHelpJButton.setToolTipText("Help");
        this.enzymesHelpJButton.setBorder(null);
        this.enzymesHelpJButton.setBorderPainted(false);
        this.enzymesHelpJButton.setContentAreaFilled(false);
        this.enzymesHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                EnzymesDialog.this.enzymesHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                EnzymesDialog.this.enzymesHelpJButtonMouseExited(evt);
            }
        });
        this.enzymesHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnzymesDialog.this.enzymesHelpJButtonActionPerformed(evt);
            }
        });
        GroupLayout enzymesEditorPanelLayout = new GroupLayout(this.enzymesEditorPanel);
        this.enzymesEditorPanel.setLayout(enzymesEditorPanelLayout);
        enzymesEditorPanelLayout.setHorizontalGroup(enzymesEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(enzymesEditorPanelLayout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.enzymesHelpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 700, Short.MAX_VALUE).addComponent(this.okButton).addContainerGap()).addGroup(enzymesEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(enzymesEditorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.enzymesPanel, -1, -1, Short.MAX_VALUE).addContainerGap())));
        enzymesEditorPanelLayout.setVerticalGroup(enzymesEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(enzymesEditorPanelLayout.createSequentialGroup().addContainerGap(503, Short.MAX_VALUE).addGroup(enzymesEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.okButton).addComponent(this.enzymesHelpJButton, -2, 23, -2)).addContainerGap()).addGroup(enzymesEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(enzymesEditorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.enzymesPanel, -1, -1, Short.MAX_VALUE).addGap(43, 43, 43))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 790, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.enzymesEditorPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 537, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.enzymesEditorPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0))));
        this.pack();
    }

    private void enzymesTableMouseMoved(MouseEvent evt) {
        int row = this.enzymesTable.rowAtPoint(evt.getPoint());
        int column = this.enzymesTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.enzymesTable.getColumn("PSI-MOD").getModelIndex() && this.enzymesTable.getValueAt(row, column) != null) {
                String tempValue = (String)this.enzymesTable.getValueAt(row, column);
                if (tempValue.lastIndexOf("<a href=\"") != -1) {
                    this.setCursor(new Cursor(12));
                } else {
                    this.setCursor(new Cursor(0));
                }
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void enzymesTableMouseClicked(MouseEvent evt) {
        this.deleteEnzymeButton.setEnabled(this.enzymesTable.getSelectedRow() != -1);
    }

    private void enzymesTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void enzymesTableMouseReleased(MouseEvent evt) {
        int row = this.enzymesTable.rowAtPoint(evt.getPoint());
        int column = this.enzymesTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.enzymesTable.getColumn("PSI-MOD").getModelIndex() && evt.getButton() == 1 && this.enzymesTable.getValueAt(row, column) != null && ((String)this.enzymesTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
            String link = (String)this.enzymesTable.getValueAt(row, column);
            link = link.substring(link.indexOf("\"") + 1);
            link = link.substring(0, link.indexOf("\""));
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(link);
            this.setCursor(new Cursor(0));
        }
    }

    private void exportEnzymesLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportEnzymesLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportEnzymesLabelMouseReleased(MouseEvent evt) {
        File selectedFile = FileChooserUtil.getUserSelectedFile(this, ".json", "Enzymes factory file (.json)", "Export...", "user.home", "enymesFactory.json", false);
        if (selectedFile != null) {
            try {
                EnzymeFactory.saveToFile(this.enzymeFactory, selectedFile);
                JOptionPane.showMessageDialog(this, "Enzymes copied to file:\n" + selectedFile.getAbsolutePath(), "Enzymes Exported.", 1);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "An error occurred when exporting the enzymes.", "Export Failed", 0);
                e.printStackTrace();
            }
        }
    }

    private void deleteEnzymeButtonActionPerformed(ActionEvent evt) {
        int row = this.enzymesTable.getSelectedRow();
        String enzymeName = (String)this.enzymesTable.getValueAt(row, 1);
        this.enzymeFactory.removeEnzyme(enzymeName);
        this.updateEnzymesTable();
    }

    private void addUserEnzymeActionPerformed(ActionEvent evt) {
        new NewEnzymeDialog(this);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.formWindowClosing(null);
    }

    private void enzymesHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void enzymesHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void enzymesHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/EnzymesDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Enzymes - Help", 500, 10);
        this.setCursor(new Cursor(0));
    }

    private void formWindowClosing(WindowEvent evt) {
        try {
            this.enzymeFactory.saveFactory();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "An error occurred while saving the enzymes.", "Saving Error", 2);
        }
        this.dispose();
    }

    private void resetEnzymesLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void resetEnzymesLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void resetEnzymesLabelMouseReleased(MouseEvent evt) {
        EnzymeFactory.setDefaultEnzymes();
        this.enzymeFactory = EnzymeFactory.getInstance();
        this.updateEnzymesTable();
    }

    private void importEnzymesLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void importEnzymesLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void importEnzymesLabelMouseReleased(MouseEvent evt) {
        File selectedFile = FileChooserUtil.getUserSelectedFile(this, ".json", "Enzymes factory file (.json)", "Import...", "user.home", "enymesFactory.json", true);
        if (selectedFile != null) {
            try {
                this.enzymeFactory = EnzymeFactory.loadFromFile(selectedFile);
                this.updateEnzymesTable();
                JOptionPane.showMessageDialog(this, "Enzymes loaded from file:\n" + selectedFile.getAbsolutePath(), "Enzymes Imported.", 1);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "An error occurred when importing the enzymes.", "Import Failed", 0);
                e.printStackTrace();
            }
        }
    }

    public String getOlsAccessionLink(String modAccession) {
        String modAccessionInLink = modAccession.replaceAll(":", "_");
        String accessionNumberWithLink = "<html><a href=\"https://www.ebi.ac.uk/ols/ontologies/ms/terms?iri=http%3A%2F%2Fpurl.obolibrary.org%2Fobo%2F" + modAccessionInLink + "\"\"><font color=\"" + "#FFFFFF" + "\">" + modAccession + "</font></a></html>";
        return accessionNumberWithLink;
    }

    private String getFormatAminoAcidList(HashSet<Character> aminoAcidList) {
        if (aminoAcidList == null || aminoAcidList.isEmpty()) {
            return null;
        }
        String temp = aminoAcidList.toString();
        return temp.substring(1, temp.length() - 1);
    }

    public void updateEnzymesTable() {
        DefaultTableModel dm = (DefaultTableModel)this.enzymesTable.getModel();
        dm.fireTableDataChanged();
        ((TitledBorder)this.enzymesPanel.getBorder()).setTitle("Enzymes (" + this.enzymesTable.getRowCount() + ")");
        this.enzymesPanel.revalidate();
        this.enzymesPanel.repaint();
        this.deleteEnzymeButton.setEnabled(false);
    }

    private class DefaultEnzymesTable
    extends DefaultTableModel {
        private DefaultEnzymesTable() {
        }

        @Override
        public int getRowCount() {
            return EnzymesDialog.this.enzymeFactory.getEnzymes().size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Cleaves After";
                }
                case 3: {
                    return "But Not Before";
                }
                case 4: {
                    return "Cleaves Before";
                }
                case 5: {
                    return "But Not After";
                }
                case 6: {
                    return "PSI-MOD";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            Enzyme enzyme = EnzymesDialog.this.enzymeFactory.getEnzyme(EnzymesDialog.this.enzymeFactory.getSortedEnzymeNames().get(row));
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return enzyme.getName();
                }
                case 2: {
                    return EnzymesDialog.this.getFormatAminoAcidList(enzyme.getAminoAcidBefore());
                }
                case 3: {
                    return EnzymesDialog.this.getFormatAminoAcidList(enzyme.getRestrictionAfter());
                }
                case 4: {
                    return EnzymesDialog.this.getFormatAminoAcidList(enzyme.getAminoAcidAfter());
                }
                case 5: {
                    return EnzymesDialog.this.getFormatAminoAcidList(enzyme.getRestrictionBefore());
                }
                case 6: {
                    CvTerm cvTerm = enzyme.getCvTerm();
                    if (cvTerm != null) {
                        return EnzymesDialog.this.getOlsAccessionLink(cvTerm.getAccession());
                    }
                    return null;
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return Double.valueOf(0.0).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

