/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.isotopic_calculator;

import com.compomics.util.AlternateRowColoursJTable;
import com.compomics.util.enumeration.MolecularElement;
import com.compomics.util.general.IsotopicDistribution;
import com.compomics.util.general.IsotopicDistributionSpectrum;
import com.compomics.util.general.MassCalc;
import com.compomics.util.general.UnknownElementMassException;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.protein.AASequenceImpl;
import com.compomics.util.protein.MolecularFormula;
import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.Silver;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IsotopeDistributionGui
extends JFrame {
    Logger logger = LogManager.getLogger(MolecularFormula.class);
    private JTextArea txtSequence;
    private JLabel lblComp;
    private JLabel lblMass;
    private JButton calculateButton;
    private AlternateRowColoursJTable table1;
    private JPanel jpanContent;
    private JPanel headerTable;
    private JPanel spectrumPanel;
    private JSpinner spinCharge;
    private JLabel lblPeptide;
    private AASequenceImpl iSequence = null;
    private HashMap<String, MolecularFormula> iElements;
    private double iCharge;

    public IsotopeDistributionGui(boolean lStandAlone) {
        super("Isotopic distribution calculator");
        this.$$$setupUI$$$();
        if (lStandAlone) {
            this.setContentPane(this.jpanContent);
            this.setSize(800, 800);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.setIconImage(new ImageIcon(this.getClass().getResource("/icons/compomics-utilities.png")).getImage());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
            try {
                FontSet fontSet = FontSets.createDefaultFontSet((Font)new Font("Tahoma", 0, 11), (Font)new Font("Tahoma", 0, 11), (Font)new Font("Tahoma", 1, 11));
                FontPolicy fixedPolicy = FontPolicies.createFixedPolicy((FontSet)fontSet);
                PlasticLookAndFeel.setFontPolicy((FontPolicy)fixedPolicy);
                PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new Silver());
                UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.iElements = new HashMap();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("elements.txt")));
            String[] lHeaderElements = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                if (line.startsWith("Header")) {
                    String lTemp = line.substring(line.indexOf("=") + 1);
                    lHeaderElements = lTemp.split(",");
                    continue;
                }
                String lAa = line.substring(0, line.indexOf("="));
                String[] lContribution = line.substring(line.indexOf("=") + 1).split(",");
                MolecularFormula lAaFormula = new MolecularFormula();
                for (int i = 0; i < lHeaderElements.length; ++i) {
                    for (MolecularElement lMolecularElement : MolecularElement.values()) {
                        if (!lMolecularElement.toString().equalsIgnoreCase(lHeaderElements[i])) continue;
                        lAaFormula.addElement(lMolecularElement, Integer.valueOf(lContribution[i]));
                    }
                }
                this.iElements.put(lAa, lAaFormula);
            }
            br.close();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        this.calculateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IsotopeDistributionGui.this.calculate();
            }
        });
        this.spinCharge.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                IsotopeDistributionGui.this.calculate();
            }
        });
    }

    public void calculate() {
        String lSeq = this.txtSequence.getText();
        lSeq = lSeq.trim().toUpperCase();
        lSeq = lSeq.replace("\n", "");
        lSeq = lSeq.replace("\t", "");
        lSeq = lSeq.replace(" ", "");
        for (int i = 0; i < lSeq.length(); ++i) {
            String lLetter = String.valueOf(lSeq.charAt(i));
            if (this.isElement(lLetter)) continue;
            JOptionPane.showMessageDialog(this, lLetter + " at position " + (i + 1) + " is not a valid element", "Not valid element", 0);
            return;
        }
        if (lSeq.length() == 0) {
            JOptionPane.showMessageDialog(this, "Sequence cannot be of length zero!", "Not valid sequence", 0);
            return;
        }
        this.iSequence = new AASequenceImpl(lSeq);
        this.iCharge = (Double)this.spinCharge.getValue();
        this.lblComp.setText(this.iSequence.getMolecularFormula().toString());
        double lMz = this.iSequence.getMz((int)this.iCharge);
        this.lblMass.setText(String.valueOf(Math.floor(lMz * 10000.0) / 10000.0) + " Da");
        this.lblPeptide.setText("NH2-" + lSeq + "-COOH (" + this.iCharge + "+)");
        IsotopicDistribution lIso = this.iSequence.getIsotopicDistribution();
        HashMap<Double, Double> lPeaks = new HashMap<Double, Double>();
        for (int i = 0; i < 10; ++i) {
            this.table1.setValueAt(i, i, 0);
            this.table1.setValueAt(Math.floor(lIso.getPercTot()[i] * 10000.0) / 100.0, i, 1);
            this.table1.setValueAt(Math.floor(lIso.getPercMax()[i] * 10000.0) / 100.0, i, 2);
            try {
                lPeaks.put(lMz + (double)i * (new MassCalc().calculateMass("H") / this.iCharge), lIso.getPercMax()[i]);
                continue;
            }
            catch (UnknownElementMassException ume) {
                this.logger.error(ume.getMessage(), (Throwable)ume);
            }
        }
        this.table1.updateUI();
        IsotopicDistributionSpectrum lSpecFile = new IsotopicDistributionSpectrum();
        lSpecFile.setCharge(Integer.valueOf(String.valueOf(this.iCharge).substring(0, String.valueOf(this.iCharge).indexOf("."))));
        lSpecFile.setPrecursorMZ(lMz);
        lSpecFile.setPeaks(lPeaks);
        this.spectrumPanel.removeAll();
        SpectrumPanel lSpecPanel = new SpectrumPanel(lSpecFile, false);
        lSpecPanel.rescale(lMz - 0.5 / this.iCharge, lMz + 0.5 / this.iCharge + 10.0 / this.iCharge);
        this.spectrumPanel.add(lSpecPanel);
        this.spectrumPanel.updateUI();
    }

    @Override
    public JPanel getContentPane() {
        return this.jpanContent;
    }

    public boolean isElement(String lElement) {
        MolecularFormula lValue = this.iElements.get(lElement);
        return lValue != null;
    }

    public static void main(String[] Args) {
        new IsotopeDistributionGui(true);
    }

    private void createUIComponents() {
        String[] columnNames = new String[]{"Isotope Number", "% Total", "% Maximum"};
        SparseTableModel lModel = new SparseTableModel(10, columnNames);
        for (int i = 0; i < 10; ++i) {
            lModel.setValueAt(i, i, 0);
            lModel.setValueAt(0.0, i, 1);
            lModel.setValueAt(0.0, i, 2);
        }
        this.table1 = new AlternateRowColoursJTable(lModel);
        this.headerTable = new JPanel();
        this.headerTable.setLayout(new BoxLayout(this.headerTable, 1));
        this.headerTable.add(this.table1.getTableHeader());
        this.spectrumPanel = new JPanel();
        this.spectrumPanel.setLayout(new BoxLayout(this.spectrumPanel, 0));
        this.spectrumPanel.add(Box.createVerticalStrut(1));
        this.spectrumPanel.add(new ImagePanel("icons/compomics.png"));
        this.spectrumPanel.add(Box.createVerticalGlue());
        this.spinCharge = new JSpinner();
        this.spinCharge.setModel(new SpinnerNumberModel(1.0, 1.0, 20.0, 1.0));
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.jpanContent = new JPanel();
        this.jpanContent.setLayout(new GridBagLayout());
        JLabel label1 = new JLabel();
        label1.setHorizontalAlignment(11);
        label1.setText("Composition:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 13;
        gbc.ipadx = 30;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.jpanContent.add((Component)label1, gbc);
        JLabel label2 = new JLabel();
        label2.setHorizontalAlignment(11);
        label2.setText("M/Z");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 13;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.jpanContent.add((Component)label2, gbc);
        this.lblComp = new JLabel();
        this.lblComp.setFont(new Font(this.lblComp.getFont().getName(), this.lblComp.getFont().getStyle(), 16));
        this.lblComp.setText("/");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.jpanContent.add((Component)this.lblComp, gbc);
        this.lblMass = new JLabel();
        this.lblMass.setFont(new Font(this.lblMass.getFont().getName(), this.lblMass.getFont().getStyle(), 16));
        this.lblMass.setText("/");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.jpanContent.add((Component)this.lblMass, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 6;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 10, 10, 10);
        this.jpanContent.add((Component)this.table1, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 6;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 0, 10);
        this.jpanContent.add((Component)this.headerTable, gbc);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        panel1.setMaximumSize(new Dimension(50, 50));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 6;
        gbc.weighty = 0.5;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.jpanContent.add((Component)panel1, gbc);
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setHorizontalScrollBarPolicy(30);
        scrollPane1.setMaximumSize(new Dimension(50, 50));
        scrollPane1.setVerticalScrollBarPolicy(20);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.1;
        gbc.weighty = 0.5;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        panel1.add((Component)scrollPane1, gbc);
        this.txtSequence = new JTextArea();
        this.txtSequence.setMaximumSize(new Dimension(50, 50));
        scrollPane1.setViewportView(this.txtSequence);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 6;
        gbc.gridheight = 6;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.jpanContent.add((Component)this.spectrumPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.jpanContent.add((Component)this.spinCharge, gbc);
        JLabel label3 = new JLabel();
        label3.setHorizontalAlignment(11);
        label3.setText("Charge:");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.anchor = 13;
        gbc.ipadx = 30;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.jpanContent.add((Component)label3, gbc);
        this.calculateButton = new JButton();
        this.calculateButton.setText("Calculate");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.jpanContent.add((Component)this.calculateButton, gbc);
        JSeparator separator1 = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 6;
        gbc.fill = 1;
        this.jpanContent.add((Component)separator1, gbc);
        this.lblPeptide = new JLabel();
        this.lblPeptide.setFont(new Font(this.lblPeptide.getFont().getName(), 2, 18));
        this.lblPeptide.setHorizontalAlignment(0);
        this.lblPeptide.setHorizontalTextPosition(0);
        this.lblPeptide.setText(" ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 6;
        this.jpanContent.add((Component)this.lblPeptide, gbc);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.jpanContent;
    }

    class SparseTableModel
    extends AbstractTableModel {
        private Hashtable lookup;
        private final int rows;
        private final int columns;
        private final String[] headers;

        public SparseTableModel(int rows, String[] columnHeaders) {
            if (rows < 0 || columnHeaders == null) {
                throw new IllegalArgumentException("Invalid row count/columnHeaders");
            }
            this.rows = rows;
            this.columns = columnHeaders.length;
            this.headers = columnHeaders;
            this.lookup = new Hashtable();
        }

        @Override
        public int getColumnCount() {
            return this.columns;
        }

        @Override
        public int getRowCount() {
            return this.rows;
        }

        @Override
        public String getColumnName(int column) {
            return this.headers[column];
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.lookup.get(new Point(row, column));
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (this.rows < 0 || this.columns < 0) {
                throw new IllegalArgumentException("Invalid row/column setting");
            }
            if (row < this.rows && column < this.columns) {
                this.lookup.put(new Point(row, column), value);
            }
        }
    }

    class ImagePanel
    extends JPanel {
        private BufferedImage image;

        public ImagePanel(String lFilename) {
            try {
                this.image = ImageIO.read(this.getClass().getResource("/" + lFilename));
            }
            catch (IOException ex) {
                IsotopeDistributionGui.this.logger.error((Object)ex);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(this.image, 0, 0, null);
        }
    }
}

