/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification;

import com.compomics.util.experiment.identification.identification_parameters.IdentificationParametersFactory;
import com.compomics.util.parameters.identification.IdentificationParameters;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class IdentificationParametersOverviewDialog
extends JDialog {
    private IdentificationParametersFactory identificationParametersFactory = IdentificationParametersFactory.getInstance();
    private JPanel backgroundPanel;
    private JLabel helpLbl;
    private JButton okButton;
    private JPopupMenu parametersPopupMenu;
    private JMenuItem removeMenuItem;
    private JTable settingsTable;
    private JScrollPane settingsTableScrollPane;
    private JPanel tablePanel;

    public IdentificationParametersOverviewDialog() {
    }

    public IdentificationParametersOverviewDialog(Dialog owner) {
        super(owner, true);
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    public IdentificationParametersOverviewDialog(Frame parentFrame) {
        super(parentFrame, true);
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.settingsTable.getColumn(" ").setMinWidth(50);
        this.settingsTable.getColumn(" ").setMaxWidth(50);
        this.settingsTable.getTableHeader().setReorderingAllowed(false);
        this.settingsTableScrollPane.getViewport().setOpaque(false);
    }

    public void updateTable() {
        ((DefaultTableModel)this.settingsTable.getModel()).fireTableDataChanged();
        this.settingsTable.getColumn(" ").setMinWidth(50);
        this.settingsTable.getColumn(" ").setMaxWidth(50);
    }

    public IdentificationParameters getIdentificationParameters() {
        String identificationParametersName = this.getSelectedParametersName();
        return this.identificationParametersFactory.getIdentificationParameters(identificationParametersName);
    }

    private void initComponents() {
        this.parametersPopupMenu = new JPopupMenu();
        this.removeMenuItem = new JMenuItem();
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.tablePanel = new JPanel();
        this.settingsTableScrollPane = new JScrollPane();
        this.settingsTable = new JTable();
        this.helpLbl = new JLabel();
        this.removeMenuItem.setText("Delete");
        this.removeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersOverviewDialog.this.removeMenuItemActionPerformed(evt);
            }
        });
        this.parametersPopupMenu.add(this.removeMenuItem);
        this.setDefaultCloseOperation(2);
        this.setTitle("Identification Settings");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersOverviewDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.tablePanel.setBorder(BorderFactory.createTitledBorder("Overview"));
        this.tablePanel.setOpaque(false);
        this.settingsTableScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                IdentificationParametersOverviewDialog.this.settingsTableScrollPaneMouseReleased(evt);
            }
        });
        this.settingsTable.setModel(new SettingsTableModel());
        this.settingsTable.setSelectionMode(0);
        this.settingsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                IdentificationParametersOverviewDialog.this.settingsTableMouseReleased(evt);
            }
        });
        this.settingsTableScrollPane.setViewportView(this.settingsTable);
        GroupLayout tablePanelLayout = new GroupLayout(this.tablePanel);
        this.tablePanel.setLayout(tablePanelLayout);
        tablePanelLayout.setHorizontalGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tablePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.settingsTableScrollPane, -1, 602, Short.MAX_VALUE).addContainerGap()));
        tablePanelLayout.setVerticalGroup(tablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tablePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.settingsTableScrollPane, -1, 345, Short.MAX_VALUE).addContainerGap()));
        this.helpLbl.setText("Right-click in the table for options");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE)).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.helpLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.helpLbl)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void settingsTableMouseReleased(MouseEvent evt) {
        this.parametersTableClicked(evt, this.settingsTable);
    }

    private void settingsTableScrollPaneMouseReleased(MouseEvent evt) {
        this.parametersTableClicked(evt, this.settingsTableScrollPane);
    }

    private void removeMenuItemActionPerformed(ActionEvent evt) {
        this.remove(this.getSelectedParametersName());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void parametersTableClicked(MouseEvent evt, Component invoker) {
        int selectedRow = -1;
        if (evt != null && this.settingsTable.rowAtPoint(evt.getPoint()) != -1) {
            selectedRow = this.settingsTable.rowAtPoint(evt.getPoint());
        }
        if (selectedRow != -1) {
            this.settingsTable.setRowSelectionInterval(selectedRow, selectedRow);
        } else {
            this.settingsTable.removeRowSelectionInterval(0, this.settingsTable.getRowCount() - 1);
        }
        if (evt != null && evt.getButton() == 3) {
            this.removeMenuItem.setVisible(selectedRow != -1);
            this.parametersPopupMenu.show(invoker, evt.getX(), evt.getY());
        }
    }

    private String getSelectedParametersName() {
        int row = this.settingsTable.getSelectedRow();
        if (row < 0 || row >= this.settingsTable.getRowCount()) {
            return null;
        }
        return this.settingsTable.getValueAt(row, 1).toString();
    }

    private void remove(String parametersName) {
        this.identificationParametersFactory.removeIdentificationParameters(parametersName);
        this.updateTable();
    }

    private class SettingsTableModel
    extends DefaultTableModel {
        private ArrayList<String> parametersNames;

        @Override
        public int getRowCount() {
            if (IdentificationParametersOverviewDialog.this.identificationParametersFactory == null) {
                return 0;
            }
            this.parametersNames = IdentificationParametersOverviewDialog.this.identificationParametersFactory.getParametersList();
            return this.parametersNames.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    String parameterName = this.parametersNames.get(row);
                    IdentificationParameters identificationParameters = IdentificationParametersOverviewDialog.this.identificationParametersFactory.getIdentificationParameters(parameterName);
                    return identificationParameters.getName();
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

