/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.advanced;

import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.advanced.ProteinInferenceParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ProteinInferenceParametersDialog
extends JDialog {
    private Frame parentFrame;
    private Image normalIcon;
    private Image waitingIcon;
    private boolean canceled = false;
    private boolean editable;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel confidenceLbl;
    private JTextField confidenceTxt;
    private JButton helpJButton;
    private JLabel modificationsLbl;
    private JComboBox modificatoinsCmb;
    private JButton okButton;
    private JPanel proteinGroupPanel;
    private JComboBox simplifyConfidenceCmb;
    private JLabel simplifyConfidenceLbl;
    private JLabel simplifyConfidenceLbl1;
    private JComboBox simplifyEnzymaticityCmb;
    private JLabel simplifyEnzymaticityLbl;
    private JComboBox simplifyEvidenceCmb;
    private JLabel simplifyEvidenceLbl;
    private JComboBox simplifyGroupsCmb;
    private JLabel simplifyGroupsLbl;
    private JComboBox simplifyVariantsCmb;
    private JLabel simplifyVariantsLbl;

    public ProteinInferenceParametersDialog() {
    }

    public ProteinInferenceParametersDialog(Frame parentFrame, ProteinInferenceParameters proteinInferencePreferences, Image normalIcon, Image waitingIcon, boolean editable) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(proteinInferencePreferences);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public ProteinInferenceParametersDialog(Dialog owner, Frame parentFrame, ProteinInferenceParameters proteinInferencePreferences, Image normalIcon, Image waitingIcon, boolean editable) {
        super(owner, true);
        this.parentFrame = parentFrame;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(proteinInferencePreferences);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.simplifyGroupsCmb.setEnabled(this.editable);
        this.simplifyEvidenceCmb.setEnabled(this.editable);
        this.simplifyConfidenceCmb.setEnabled(this.editable);
        this.simplifyEnzymaticityCmb.setEnabled(this.editable);
        this.simplifyVariantsCmb.setEnabled(this.editable);
        this.confidenceTxt.setEnabled(this.editable);
        this.modificatoinsCmb.setEnabled(this.editable);
        this.simplifyGroupsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.simplifyEvidenceCmb.setRenderer(new AlignedListCellRenderer(0));
        this.simplifyConfidenceCmb.setRenderer(new AlignedListCellRenderer(0));
        this.simplifyEnzymaticityCmb.setRenderer(new AlignedListCellRenderer(0));
        this.simplifyVariantsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.modificatoinsCmb.setRenderer(new AlignedListCellRenderer(0));
    }

    private void populateGUI(ProteinInferenceParameters proteinInferencePreferences) {
        this.okButton.setEnabled(true);
        if (proteinInferencePreferences.getSimplifyGroups()) {
            this.simplifyGroupsCmb.setSelectedIndex(0);
        } else {
            this.simplifyGroupsCmb.setSelectedIndex(1);
            this.simplifyEvidenceCmb.setEnabled(false);
            this.simplifyConfidenceCmb.setEnabled(false);
            this.simplifyEnzymaticityCmb.setEnabled(false);
            this.simplifyVariantsCmb.setEnabled(false);
            this.modificatoinsCmb.setEnabled(false);
        }
        if (proteinInferencePreferences.getSimplifyGroupsEvidence()) {
            this.simplifyEvidenceCmb.setSelectedIndex(0);
        } else {
            this.simplifyEvidenceCmb.setSelectedIndex(1);
        }
        if (proteinInferencePreferences.getSimplifyGroupsConfidence()) {
            this.simplifyConfidenceCmb.setSelectedIndex(0);
        } else {
            this.simplifyConfidenceCmb.setSelectedIndex(1);
        }
        this.confidenceTxt.setText(Double.toString(proteinInferencePreferences.getConfidenceThreshold()));
        if (proteinInferencePreferences.getSimplifyGroupsEnzymaticity()) {
            this.simplifyEnzymaticityCmb.setSelectedIndex(0);
        } else {
            this.simplifyEnzymaticityCmb.setSelectedIndex(1);
        }
        if (proteinInferencePreferences.getSimplifyGroupsVariants()) {
            this.simplifyVariantsCmb.setSelectedIndex(0);
        } else {
            this.simplifyVariantsCmb.setSelectedIndex(1);
        }
    }

    public ProteinInferenceParameters getProteinInferencePreferences() {
        ProteinInferenceParameters proteinInferencePreferences = new ProteinInferenceParameters();
        proteinInferencePreferences.setSimplifyGroups(this.simplifyGroupsCmb.getSelectedIndex() == 0);
        proteinInferencePreferences.setSimplifyGroupsEvidence(this.simplifyEvidenceCmb.getSelectedIndex() == 0);
        proteinInferencePreferences.setSimplifyGroupsConfidence(this.simplifyConfidenceCmb.getSelectedIndex() == 0);
        proteinInferencePreferences.setSimplifyGroupsEnzymaticity(this.simplifyEnzymaticityCmb.getSelectedIndex() == 0);
        proteinInferencePreferences.setSimplifyGroupsVariants(this.simplifyVariantsCmb.getSelectedIndex() == 0);
        proteinInferencePreferences.setModificationRefinement(this.modificatoinsCmb.getSelectedIndex() == 0);
        proteinInferencePreferences.setConfidenceThreshold(Double.parseDouble(this.confidenceTxt.getText()));
        return proteinInferencePreferences;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void initComponents() {
        this.simplifyConfidenceLbl1 = new JLabel();
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.proteinGroupPanel = new JPanel();
        this.simplifyGroupsLbl = new JLabel();
        this.simplifyEnzymaticityLbl = new JLabel();
        this.simplifyEvidenceLbl = new JLabel();
        this.simplifyGroupsCmb = new JComboBox();
        this.simplifyEnzymaticityCmb = new JComboBox();
        this.simplifyEvidenceCmb = new JComboBox();
        this.simplifyVariantsCmb = new JComboBox();
        this.simplifyVariantsLbl = new JLabel();
        this.simplifyConfidenceCmb = new JComboBox();
        this.simplifyConfidenceLbl = new JLabel();
        this.confidenceLbl = new JLabel();
        this.confidenceTxt = new JTextField();
        this.modificatoinsCmb = new JComboBox();
        this.modificationsLbl = new JLabel();
        this.helpJButton = new JButton();
        this.simplifyConfidenceLbl1.setText("- Based on Peptide Confidence");
        this.setDefaultCloseOperation(2);
        this.setTitle("Protein Inference");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProteinInferenceParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.proteinGroupPanel.setBorder(BorderFactory.createTitledBorder("Protein Groups Simplification"));
        this.proteinGroupPanel.setOpaque(false);
        this.simplifyGroupsLbl.setText("Simplify Protein Groups");
        this.simplifyEnzymaticityLbl.setText("- Based on Enzymaticity");
        this.simplifyEvidenceLbl.setText("- Based on UniProt Evidence Level");
        this.simplifyGroupsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.simplifyGroupsCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceParametersDialog.this.simplifyGroupsCmbActionPerformed(evt);
            }
        });
        this.simplifyEnzymaticityCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.simplifyEvidenceCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.simplifyVariantsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.simplifyVariantsLbl.setText("- Based on Variant Mapping");
        this.simplifyConfidenceCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.simplifyConfidenceLbl.setText("- Based on Peptide Confidence");
        this.confidenceLbl.setText("Confidence below which a peptide is ignored");
        this.confidenceTxt.setHorizontalAlignment(0);
        this.modificatoinsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.modificationsLbl.setText("Account for modifications in protein mapping");
        GroupLayout proteinGroupPanelLayout = new GroupLayout(this.proteinGroupPanel);
        this.proteinGroupPanel.setLayout(proteinGroupPanelLayout);
        proteinGroupPanelLayout.setHorizontalGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinGroupPanelLayout.createSequentialGroup().addContainerGap().addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.simplifyGroupsLbl).addComponent(this.modificationsLbl).addGroup(proteinGroupPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.simplifyEvidenceLbl).addComponent(this.simplifyConfidenceLbl).addGroup(proteinGroupPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.confidenceLbl)).addComponent(this.simplifyVariantsLbl).addComponent(this.simplifyEnzymaticityLbl)))).addGap(78, 78, 78).addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.simplifyGroupsCmb, GroupLayout.Alignment.TRAILING, 0, 145, Short.MAX_VALUE).addComponent(this.simplifyEvidenceCmb, GroupLayout.Alignment.TRAILING, 0, 145, Short.MAX_VALUE).addComponent(this.simplifyConfidenceCmb, GroupLayout.Alignment.TRAILING, 0, 145, Short.MAX_VALUE).addComponent(this.confidenceTxt, GroupLayout.Alignment.TRAILING, -1, 145, Short.MAX_VALUE).addComponent(this.simplifyEnzymaticityCmb, GroupLayout.Alignment.TRAILING, 0, 145, Short.MAX_VALUE).addComponent(this.simplifyVariantsCmb, GroupLayout.Alignment.TRAILING, 0, 145, Short.MAX_VALUE).addComponent(this.modificatoinsCmb, GroupLayout.Alignment.TRAILING, 0, 145, Short.MAX_VALUE)).addContainerGap()));
        proteinGroupPanelLayout.setVerticalGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinGroupPanelLayout.createSequentialGroup().addContainerGap().addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.simplifyGroupsLbl).addComponent(this.simplifyGroupsCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.simplifyEvidenceLbl).addComponent(this.simplifyEvidenceCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.simplifyConfidenceLbl).addComponent(this.simplifyConfidenceCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.confidenceLbl).addComponent(this.confidenceTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.simplifyEnzymaticityLbl).addComponent(this.simplifyEnzymaticityCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.simplifyVariantsLbl).addComponent(this.simplifyVariantsCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteinGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modificationsLbl).addComponent(this.modificatoinsCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.setFocusable(false);
        this.helpJButton.setHorizontalTextPosition(0);
        this.helpJButton.setVerticalTextPosition(3);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinInferenceParametersDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceParametersDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceParametersDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.proteinGroupPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinGroupPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/ProteinInferencePreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Protein Inference - Help");
        this.setCursor(new Cursor(0));
    }

    private void simplifyGroupsCmbActionPerformed(ActionEvent evt) {
        this.simplifyEvidenceCmb.setEnabled(this.editable && this.simplifyGroupsCmb.getSelectedIndex() == 0);
        this.simplifyConfidenceCmb.setEnabled(this.editable && this.simplifyGroupsCmb.getSelectedIndex() == 0);
        this.confidenceTxt.setEnabled(this.editable && this.simplifyGroupsCmb.getSelectedIndex() == 0);
        this.simplifyEnzymaticityCmb.setEnabled(this.editable && this.simplifyGroupsCmb.getSelectedIndex() == 0);
        this.simplifyVariantsCmb.setEnabled(this.editable && this.simplifyGroupsCmb.getSelectedIndex() == 0);
    }
}

