/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.advanced;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.psm_scoring.PsmScore;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.parameters.identification.advanced.PsmScoringParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;

public class PsmScoringParametersDialog
extends JDialog {
    private Frame parentFrame;
    private boolean canceled = false;
    private boolean editable;
    private HashMap<Integer, HashSet<Integer>> spectrumMatchingScores = null;
    private HashSet<Integer> defaultScores;
    private ArrayList<String> psmScoresTableToolTips;
    private ArrayList<String> advocateNames;
    private ArrayList<String> scoresNames;
    private JMenuItem addJMenuItem;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton helpJButton;
    private JButton okButton;
    private JScrollPane psmScoresJScrollPane;
    private JTable psmScoresJTable;
    private JPopupMenu psmScoresPopupMenu;
    private JMenuItem removeJMenuItem;
    private JPanel scoresSelectionJPanel;

    public PsmScoringParametersDialog() {
    }

    public PsmScoringParametersDialog(Frame parentFrame, PsmScoringParameters psmScoringPreferences, boolean editable) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(psmScoringPreferences);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public PsmScoringParametersDialog(Dialog owner, Frame parentFrame, PsmScoringParameters psmScoringPreferences, boolean editable) {
        super(owner, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.populateGUI(psmScoringPreferences);
        this.setUpGui();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.setTableProperties();
    }

    private void setTableProperties() {
        TableColumnModel tableColumnModel = this.psmScoresJTable.getColumnModel();
        tableColumnModel.getColumn(0).setMaxWidth(30);
        this.psmScoresJScrollPane.getViewport().setOpaque(false);
        for (int i = 0; i < PsmScore.values().length; ++i) {
            tableColumnModel.getColumn(i + 2).setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/selected_green-new.png")), null, "On", "Off"));
        }
    }

    private void populateGUI(PsmScoringParameters psmScoringPreferences) {
        PsmScore[] psmScores = PsmScore.values();
        this.scoresNames = new ArrayList(psmScores.length);
        for (PsmScore psmScore : psmScores) {
            this.scoresNames.add(psmScore.name);
        }
        Set<Integer> advocates = psmScoringPreferences.getAdvocates();
        this.spectrumMatchingScores = new HashMap(advocates.size());
        for (Integer advocate : advocates) {
            HashSet<Integer> scores = new HashSet<Integer>(psmScoringPreferences.getScoreForAlgorithm(advocate));
            this.spectrumMatchingScores.put(advocate, scores);
        }
        this.defaultScores = new HashSet<Integer>(psmScoringPreferences.getDefaultScores());
        this.advocateNames = new ArrayList(this.spectrumMatchingScores.size());
        for (Integer advocateId : advocates) {
            Advocate advocate = Advocate.getAdvocate(advocateId);
            this.advocateNames.add(advocate.getName());
        }
        Collections.sort(this.advocateNames);
        this.psmScoresJTable.setModel(new AlgorithmScoresTableModel());
        PsmScore[] implementedScores = PsmScore.values();
        this.psmScoresTableToolTips = new ArrayList(implementedScores.length);
        this.psmScoresTableToolTips.add(null);
        this.psmScoresTableToolTips.add("Score Name");
        for (PsmScore psmScore : implementedScores) {
            this.psmScoresTableToolTips.add(psmScore.description);
        }
    }

    private void updateTableContent() {
        ((DefaultTableModel)this.psmScoresJTable.getModel()).fireTableDataChanged();
    }

    public PsmScoringParameters getPsmScoringPreferences() {
        PsmScoringParameters psmScoringPreferences = new PsmScoringParameters();
        psmScoringPreferences.clearAllScores();
        for (Integer algorithm : this.spectrumMatchingScores.keySet()) {
            HashSet<Integer> scores = this.spectrumMatchingScores.get(algorithm);
            for (Integer score : scores) {
                psmScoringPreferences.addScore(algorithm, score);
            }
        }
        return psmScoringPreferences;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void initComponents() {
        this.psmScoresPopupMenu = new JPopupMenu();
        this.addJMenuItem = new JMenuItem();
        this.removeJMenuItem = new JMenuItem();
        this.backgroundPanel = new JPanel();
        this.scoresSelectionJPanel = new JPanel();
        this.psmScoresJScrollPane = new JScrollPane();
        this.psmScoresJTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)PsmScoringParametersDialog.this.psmScoresTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.helpJButton = new JButton();
        this.addJMenuItem.setText("Add");
        this.addJMenuItem.setEnabled(false);
        this.addJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PsmScoringParametersDialog.this.addJMenuItemActionPerformed(evt);
            }
        });
        this.psmScoresPopupMenu.add(this.addJMenuItem);
        this.removeJMenuItem.setText("Remove");
        this.removeJMenuItem.setEnabled(false);
        this.removeJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PsmScoringParametersDialog.this.removeJMenuItemActionPerformed(evt);
            }
        });
        this.psmScoresPopupMenu.add(this.removeJMenuItem);
        this.setDefaultCloseOperation(2);
        this.setTitle("PSM Scoring");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PsmScoringParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.backgroundPanel.setToolTipText("PSM Scoring");
        this.scoresSelectionJPanel.setBorder(BorderFactory.createTitledBorder("PSM Scores Selection"));
        this.scoresSelectionJPanel.setOpaque(false);
        this.psmScoresJTable.setModel(new AlgorithmScoresTableModel());
        this.psmScoresJTable.getTableHeader().setReorderingAllowed(false);
        this.psmScoresJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                PsmScoringParametersDialog.this.psmScoresJTableMouseReleased(evt);
            }
        });
        this.psmScoresJScrollPane.setViewportView(this.psmScoresJTable);
        GroupLayout scoresSelectionJPanelLayout = new GroupLayout(this.scoresSelectionJPanel);
        this.scoresSelectionJPanel.setLayout(scoresSelectionJPanelLayout);
        scoresSelectionJPanelLayout.setHorizontalGroup(scoresSelectionJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scoresSelectionJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmScoresJScrollPane, -1, 587, Short.MAX_VALUE).addContainerGap()));
        scoresSelectionJPanelLayout.setVerticalGroup(scoresSelectionJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scoresSelectionJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmScoresJScrollPane, -1, 155, Short.MAX_VALUE).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PsmScoringParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PsmScoringParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.setFocusable(false);
        this.helpJButton.setHorizontalTextPosition(0);
        this.helpJButton.setVerticalTextPosition(3);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PsmScoringParametersDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PsmScoringParametersDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PsmScoringParametersDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.scoresSelectionJPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.scoresSelectionJPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void psmScoresJTableMouseReleased(MouseEvent evt) {
        if (evt.getButton() == 1) {
            int row = this.psmScoresJTable.getSelectedRow();
            int column = this.psmScoresJTable.getSelectedColumn();
            if (column > 1 && row < this.advocateNames.size()) {
                String advocateName = this.advocateNames.get(row);
                Advocate advocate = Advocate.getAdvocate(advocateName);
                Integer advocateIndex = advocate.getIndex();
                HashSet<Integer> scores = this.spectrumMatchingScores.get(advocateIndex);
                String scoreName = this.scoresNames.get(column - 2);
                PsmScore psmScore = PsmScore.getScore(scoreName);
                Integer scoreIndex = psmScore.index;
                if (scores.contains(scoreIndex)) {
                    scores.remove(scoreIndex);
                } else {
                    scores.add(scoreIndex);
                }
                if (scores.isEmpty()) {
                    scores.add(PsmScore.native_score.index);
                }
                this.updateTableContent();
            }
        } else if (evt.getButton() == 3) {
            this.psmScoresJTable.setRowSelectionInterval(this.psmScoresJTable.rowAtPoint(evt.getPoint()), this.psmScoresJTable.rowAtPoint(evt.getPoint()));
            this.psmScoresPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void addJMenuItemActionPerformed(ActionEvent evt) {
    }

    private void removeJMenuItemActionPerformed(ActionEvent evt) {
        int row = this.psmScoresJTable.getSelectedRow();
        String advocateName = this.advocateNames.get(row);
        Advocate advocate = Advocate.getAdvocate(advocateName);
        Integer advocateIndex = advocate.getIndex();
        this.spectrumMatchingScores.remove(advocateIndex);
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/PsmScoringPreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "PSM Scoring - Help");
        this.setCursor(new Cursor(0));
    }

    private class AlgorithmScoresTableModel
    extends DefaultTableModel {
        @Override
        public int getRowCount() {
            if (PsmScoringParametersDialog.this.advocateNames == null) {
                return 0;
            }
            return PsmScoringParametersDialog.this.advocateNames.size() + 1;
        }

        @Override
        public int getColumnCount() {
            if (PsmScoringParametersDialog.this.scoresNames == null) {
                return 0;
            }
            return PsmScoringParametersDialog.this.scoresNames.size() + 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return " ";
            }
            if (column == 1) {
                return "  ";
            }
            return (String)PsmScoringParametersDialog.this.scoresNames.get(column - 2);
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    if (row < PsmScoringParametersDialog.this.advocateNames.size()) {
                        return PsmScoringParametersDialog.this.advocateNames.get(row);
                    }
                    return "Default";
                }
            }
            String scoreName = (String)PsmScoringParametersDialog.this.scoresNames.get(column - 2);
            PsmScore psmScore = PsmScore.getScore(scoreName);
            Integer scoreIndex = psmScore.index;
            if (row < PsmScoringParametersDialog.this.advocateNames.size()) {
                String name = (String)PsmScoringParametersDialog.this.advocateNames.get(row);
                Advocate advocate = Advocate.getAdvocate(name);
                Integer index = advocate.getIndex();
                HashSet algorithmScores = (HashSet)PsmScoringParametersDialog.this.spectrumMatchingScores.get(index);
                if (algorithmScores == null || algorithmScores.isEmpty()) {
                    return false;
                }
                return algorithmScores.contains(scoreIndex);
            }
            return PsmScoringParametersDialog.this.defaultScores.contains(scoreIndex);
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (PsmScoringParametersDialog.this.advocateNames == null) {
                return false;
            }
            return columnIndex > 1 && rowIndex < PsmScoringParametersDialog.this.advocateNames.size();
        }
    }
}

