/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.advanced;

import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.parameters.identification.advanced.IdMatchValidationParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ValidationParametersDialog
extends JDialog {
    private Frame parentFrame;
    private boolean canceled = false;
    private boolean editable;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton helpJButton;
    private JButton okButton;
    private JLabel peptideFdrLabel;
    private JTextField peptideFdrTxt;
    private JPanel processingParamsPanel;
    private JLabel proteinFdrLabel;
    private JTextField proteinFdrTxt;
    private JLabel psmFdrLabel;
    private JTextField psmFdrTxt;

    public ValidationParametersDialog() {
    }

    public ValidationParametersDialog(Frame parentFrame, IdMatchValidationParameters idMatchValidationPreferences, boolean editable) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(idMatchValidationPreferences);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public ValidationParametersDialog(Dialog owner, Frame parentFrame, IdMatchValidationParameters idMatchValidationPreferences, boolean editable) {
        super(owner, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(idMatchValidationPreferences);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.proteinFdrTxt.setEditable(this.editable);
        this.proteinFdrTxt.setEnabled(this.editable);
        this.peptideFdrTxt.setEditable(this.editable);
        this.peptideFdrTxt.setEnabled(this.editable);
        this.psmFdrTxt.setEditable(this.editable);
        this.psmFdrTxt.setEnabled(this.editable);
    }

    private void populateGUI(IdMatchValidationParameters idMatchValidationPreferences) {
        this.proteinFdrTxt.setText(Double.toString(idMatchValidationPreferences.getDefaultProteinFDR()));
        this.peptideFdrTxt.setText(Double.toString(idMatchValidationPreferences.getDefaultPeptideFDR()));
        this.psmFdrTxt.setText(Double.toString(idMatchValidationPreferences.getDefaultPsmFDR()));
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public IdMatchValidationParameters getIdMatchValidationPreferences() {
        IdMatchValidationParameters idMatchValidationPreferences = new IdMatchValidationParameters();
        idMatchValidationPreferences.setDefaultProteinFDR(Double.valueOf(this.proteinFdrTxt.getText().trim()));
        idMatchValidationPreferences.setDefaultPeptideFDR(Double.valueOf(this.peptideFdrTxt.getText().trim()));
        idMatchValidationPreferences.setDefaultPsmFDR(Double.valueOf(this.psmFdrTxt.getText().trim()));
        return idMatchValidationPreferences;
    }

    public boolean validateInput() {
        Double temp;
        try {
            temp = Double.valueOf(this.proteinFdrTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the protein FDR.", "Input Error", 0);
                this.proteinFdrTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the protein FDR.", "Input Error", 0);
            this.proteinFdrTxt.requestFocus();
            return false;
        }
        try {
            temp = Double.valueOf(this.peptideFdrTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the peptide FDR.", "Input Error", 0);
                this.peptideFdrTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the peptide FDR.", "Input Error", 0);
            this.peptideFdrTxt.requestFocus();
            return false;
        }
        try {
            temp = Double.valueOf(this.psmFdrTxt.getText().trim());
            if (temp < 0.0 || temp > 100.0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the PSM FDR.", "Input Error", 0);
                this.psmFdrTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the PSM FDR.", "Input Error", 0);
            this.psmFdrTxt.requestFocus();
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.processingParamsPanel = new JPanel();
        this.proteinFdrLabel = new JLabel();
        this.peptideFdrLabel = new JLabel();
        this.psmFdrLabel = new JLabel();
        this.psmFdrTxt = new JTextField();
        this.peptideFdrTxt = new JTextField();
        this.proteinFdrTxt = new JTextField();
        this.helpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Validation Levels");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ValidationParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.processingParamsPanel.setBorder(BorderFactory.createTitledBorder("Default FDR Levels"));
        this.processingParamsPanel.setOpaque(false);
        this.proteinFdrLabel.setText("Protein FDR (%)");
        this.peptideFdrLabel.setText("Peptide FDR (%)");
        this.psmFdrLabel.setText("PSM FDR (%)");
        this.psmFdrTxt.setHorizontalAlignment(0);
        this.psmFdrTxt.setText("1");
        this.peptideFdrTxt.setHorizontalAlignment(0);
        this.peptideFdrTxt.setText("1");
        this.proteinFdrTxt.setHorizontalAlignment(0);
        this.proteinFdrTxt.setText("1");
        GroupLayout processingParamsPanelLayout = new GroupLayout(this.processingParamsPanel);
        this.processingParamsPanel.setLayout(processingParamsPanelLayout);
        processingParamsPanelLayout.setHorizontalGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processingParamsPanelLayout.createSequentialGroup().addContainerGap().addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinFdrLabel, -2, 150, -2).addComponent(this.peptideFdrLabel, -2, 150, -2).addComponent(this.psmFdrLabel, -2, 150, -2)).addGap(5, 5, 5).addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psmFdrTxt, GroupLayout.Alignment.TRAILING, -1, 135, Short.MAX_VALUE).addComponent(this.peptideFdrTxt).addComponent(this.proteinFdrTxt, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        processingParamsPanelLayout.setVerticalGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processingParamsPanelLayout.createSequentialGroup().addContainerGap().addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteinFdrTxt, -2, -1, -2).addComponent(this.proteinFdrLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peptideFdrTxt, -2, -1, -2).addComponent(this.peptideFdrLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(processingParamsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psmFdrLabel).addComponent(this.psmFdrTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.setFocusable(false);
        this.helpJButton.setHorizontalTextPosition(0);
        this.helpJButton.setVerticalTextPosition(3);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ValidationParametersDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ValidationParametersDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ValidationParametersDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.processingParamsPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.processingParamsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/ValidationPreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Validation Levels - Help");
        this.setCursor(new Cursor(0));
    }
}

