/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.pride;

import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class EnzymeParametersDialog
extends JDialog {
    private EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
    private boolean selectionCanceled = false;
    private boolean editable;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel enzymeLabel;
    private JComboBox enzymesCmb;
    private JPanel mappingPanel;
    private JButton okButton;
    private JLabel prideEnzymeNameLabel;
    private JTextField prideEnzymeNameTextField;

    public EnzymeParametersDialog() {
    }

    public EnzymeParametersDialog(Frame parent, boolean modal, String enzymeName, boolean editable) {
        super(parent, modal);
        this.initComponents();
        this.prideEnzymeNameTextField.setText(enzymeName);
        this.enzymesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.editable = editable;
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public EnzymeParametersDialog(Dialog owner, Frame parent, boolean modal, String enzymeName, boolean editable) {
        super(owner, modal);
        this.initComponents();
        this.prideEnzymeNameTextField.setText(enzymeName);
        this.enzymesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.editable = editable;
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    public EnzymeParametersDialog(JDialog parent, boolean modal, String enzymeName) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.setUpGui();
        this.populateGui(enzymeName);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.enzymesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.enzymesCmb.setEnabled(this.editable);
    }

    private void populateGui(String enzymeName) {
        this.prideEnzymeNameTextField.setText(enzymeName);
    }

    public Enzyme getEnzyme() {
        if (!this.selectionCanceled) {
            return this.enzymeFactory.getEnzyme(this.enzymesCmb.getSelectedItem().toString());
        }
        return null;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.mappingPanel = new JPanel();
        this.enzymesCmb = new JComboBox();
        this.enzymeLabel = new JLabel();
        this.prideEnzymeNameLabel = new JLabel();
        this.prideEnzymeNameTextField = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Enzyme");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EnzymeParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.mappingPanel.setBorder(BorderFactory.createTitledBorder("Enzyme Selection"));
        this.mappingPanel.setOpaque(false);
        this.enzymesCmb.setModel(new DefaultComboBoxModel<String>(this.loadEnzymes()));
        this.enzymesCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnzymeParametersDialog.this.enzymesCmbActionPerformed(evt);
            }
        });
        this.enzymeLabel.setText("Enzyme");
        this.prideEnzymeNameLabel.setText("PRIDE");
        this.prideEnzymeNameTextField.setEditable(false);
        this.prideEnzymeNameTextField.setHorizontalAlignment(0);
        GroupLayout mappingPanelLayout = new GroupLayout(this.mappingPanel);
        this.mappingPanel.setLayout(mappingPanelLayout);
        mappingPanelLayout.setHorizontalGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mappingPanelLayout.createSequentialGroup().addContainerGap().addGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enzymeLabel).addComponent(this.prideEnzymeNameLabel)).addGap(18, 18, 18).addGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enzymesCmb, 0, -1, Short.MAX_VALUE).addComponent(this.prideEnzymeNameTextField)).addContainerGap()));
        mappingPanelLayout.setVerticalGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mappingPanelLayout.createSequentialGroup().addContainerGap().addGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.prideEnzymeNameLabel).addComponent(this.prideEnzymeNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mappingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enzymeLabel).addComponent(this.enzymesCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnzymeParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnzymeParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.mappingPanel, -1, -1, Short.MAX_VALUE)).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(0, 380, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.mappingPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.selectionCanceled = true;
        this.okButtonActionPerformed(null);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    private void enzymesCmbActionPerformed(ActionEvent evt) {
        this.okButton.setEnabled(this.enzymesCmb.getSelectedIndex() > 0);
    }

    private String[] loadEnzymes() {
        ArrayList<String> tempEnzymes = new ArrayList<String>();
        for (int i = 0; i < this.enzymeFactory.getEnzymes().size(); ++i) {
            tempEnzymes.add(this.enzymeFactory.getEnzymes().get(i).getName());
        }
        Collections.sort(tempEnzymes);
        String[] enzymes = new String[tempEnzymes.size() + 1];
        enzymes[0] = "--- Select ---";
        for (int i = 0; i < tempEnzymes.size(); ++i) {
            enzymes[i + 1] = (String)tempEnzymes.get(i);
        }
        return enzymes;
    }
}

