/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.renderers;

import java.awt.Color;
import java.awt.Component;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ToolTipComboBoxRenderer
extends BasicComboBoxRenderer {
    private Vector tooltips;
    private int align;
    private final int MAX_TOOLTIP_WIDTH = 40;
    private Color backgroundColor = Color.WHITE;

    public ToolTipComboBoxRenderer() {
    }

    public ToolTipComboBoxRenderer(Vector tooltips, int align) {
        this.tooltips = tooltips;
        this.align = align;
    }

    public ToolTipComboBoxRenderer(Vector tooltips, int align, Color backgroundColor) {
        this.tooltips = tooltips;
        this.align = align;
        this.backgroundColor = backgroundColor;
    }

    public void setToolTips(Vector tooltips) {
        this.tooltips = tooltips;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel lbl = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (isSelected) {
            lbl.setBackground(list.getSelectionBackground());
            lbl.setForeground(list.getSelectionForeground());
            if (this.tooltips != null) {
                if (-1 < index && index < this.tooltips.size()) {
                    if (this.tooltips.get(index) != null) {
                        String toolTip = (String)this.tooltips.get(index);
                        StringTokenizer tok = new StringTokenizer(toolTip);
                        String temp = "";
                        String temp2 = "";
                        while (tok.hasMoreTokens()) {
                            if ((temp = temp + tok.nextToken() + " ").length() <= 40) continue;
                            temp2 = temp2 + temp + "<br>";
                            temp = "";
                        }
                        if (temp.length() > 0) {
                            temp2 = temp2 + temp;
                        }
                        list.setToolTipText("<html>" + temp2 + "</html>");
                    } else {
                        list.setToolTipText(null);
                    }
                }
            } else {
                list.setToolTipText(null);
            }
        } else {
            lbl.setBackground(this.backgroundColor);
            lbl.setForeground(list.getForeground());
        }
        lbl.setFont(list.getFont());
        lbl.setText(value == null ? "" : value.toString());
        if (("" + value).length() < 60) {
            lbl.setHorizontalAlignment(this.align);
        } else {
            lbl.setHorizontalAlignment(10);
        }
        return lbl;
    }
}

