/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.IonFactory;
import com.compomics.util.experiment.biology.ions.NeutralLossCombination;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.table.DefaultTableModel;

public class IonLabelColorTableModel
extends DefaultTableModel {
    private HashMap<String, Ion> ionMap;
    private ArrayList<String> keys;
    private IonFactory ionFactory = IonFactory.getInstance();

    public IonLabelColorTableModel(HashMap<Ion.IonType, HashSet<Integer>> iontypes, HashSet<String> neutralLosses) {
        this.ionMap = new HashMap();
        this.keys = new ArrayList();
        block4: for (Ion.IonType ionType : iontypes.keySet()) {
            if (null == ionType) continue;
            switch (ionType) {
                case IMMONIUM_ION: {
                    this.ionMap.put("Immonium Ion", Ion.getGenericIon(ionType, 0));
                    this.keys.add("Immonium Ion");
                    continue block4;
                }
                case RELATED_ION: {
                    this.ionMap.put("Related Ion", Ion.getGenericIon(ionType, 0));
                    this.keys.add("Related Ion");
                    continue block4;
                }
            }
            for (Integer subtype : iontypes.get((Object)ionType)) {
                Ion currentIon;
                if (ionType == Ion.IonType.REPORTER_ION) {
                    currentIon = Ion.getGenericIon(ionType, subtype);
                    String key = currentIon.getName();
                    this.ionMap.put(key, currentIon);
                    this.keys.add(key);
                    continue;
                }
                for (NeutralLossCombination possibleCombination : this.ionFactory.getNeutralLossesCombinations(neutralLosses)) {
                    currentIon = Ion.getGenericIon(ionType, subtype, possibleCombination.getNeutralLossCombination());
                    String key = currentIon.getName();
                    this.ionMap.put(key, currentIon);
                    this.keys.add(key);
                }
            }
        }
    }

    public Ion getIonAtRow(int rowIndex) {
        return this.ionMap.get(this.keys.get(rowIndex));
    }

    public IonLabelColorTableModel() {
        this.ionMap = new HashMap();
        this.keys = new ArrayList();
    }

    @Override
    public int getRowCount() {
        if (this.keys == null) {
            return 0;
        }
        return this.keys.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return " ";
            }
            case 1: {
                return "Ion";
            }
            case 2: {
                return "  ";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return row + 1;
            }
            case 1: {
                return this.keys.get(row);
            }
            case 2: {
                return SpectrumPanel.determineFragmentIonColor(this.ionMap.get(this.keys.get(row)), true);
            }
        }
        return "";
    }

    public Class getColumnClass(int columnIndex) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, columnIndex) == null) continue;
            return this.getValueAt(i, columnIndex).getClass();
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 2;
    }
}

