/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.utils.user_choice.list_choosers;

import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.gui.utils.user_choice.ListChooser;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesColorTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;

public class ModificationChooser
extends ListChooser {
    private ModificationFactory modificationsFactory = ModificationFactory.getInstance();
    private ArrayList<String> modificationsList = new ArrayList();

    public ModificationChooser() {
    }

    public ModificationChooser(Frame parent, ArrayList<String> modifications, String dialogTitle, String panelTitle, String instructionsLabel, boolean multipleSelection) {
        super(parent, modifications, dialogTitle, panelTitle, instructionsLabel, multipleSelection);
        this.modificationsList = modifications;
        if (modifications == null || modifications.isEmpty()) {
            throw new IllegalArgumentException("No item to select.");
        }
        this.setUpTable();
        this.setVisible(true);
    }

    public ModificationChooser(JDialog parent, ArrayList<String> modifications, String dialogTitle, String panelTitle, String instructionsLabel, boolean multipleSelection) {
        super(parent, modifications, dialogTitle, panelTitle, instructionsLabel, multipleSelection);
        this.modificationsList = modifications;
        if (modifications == null || modifications.isEmpty()) {
            throw new IllegalArgumentException("No item to select.");
        }
        this.setUpTable();
        this.setVisible(true);
    }

    public ModificationChooser(Frame parent, ArrayList<String> modifications, boolean multipleSelection) {
        this(parent, modifications, "Modification Selection", "Searched Modifications", "Please select a modification from the list of possibilities.", multipleSelection);
    }

    public ModificationChooser(JDialog parent, ArrayList<String> modifications, boolean multipleSelection) {
        this(parent, modifications, "Modification Selection", "Searched Modifications", "Please select a modification from the list of possibilities.", multipleSelection);
    }

    @Override
    protected void formatTable() {
        JTable modificationsJTable = this.getTable();
        modificationsJTable.setModel(new ModificationsTableModel());
        double minMass = this.modificationsList.stream().map(modName -> this.modificationsFactory.getModification((String)modName)).mapToDouble(Modification::getMass).min().orElse(0.0);
        double maxMass = this.modificationsList.stream().map(modName -> this.modificationsFactory.getModification((String)modName)).mapToDouble(Modification::getMass).max().orElse(0.0);
        modificationsJTable.getColumn(" ").setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        modificationsJTable.getColumn(" ").setMaxWidth(35);
        modificationsJTable.getColumn("Mass").setMaxWidth(100);
        modificationsJTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(minMass), Double.valueOf(maxMass)));
        ((JSparklinesBarChartTableCellRenderer)modificationsJTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 50);
        ArrayList<String> modificationTableToolTips = this.getTableTooltips();
        modificationTableToolTips.add(null);
        modificationTableToolTips.add("Modification Name");
        modificationTableToolTips.add("Modification Mass");
        modificationTableToolTips.add("Default Modification");
    }

    private class ModificationsTableModel
    extends DefaultTableModel {
        private ModificationsTableModel() {
        }

        @Override
        public int getRowCount() {
            return ModificationChooser.this.modificationsList.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Mass";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String modName = (String)ModificationChooser.this.modificationsList.get(row);
            switch (column) {
                case 0: {
                    return ModificationChooser.this.modificationsFactory.getColor(modName);
                }
                case 1: {
                    return modName;
                }
                case 2: {
                    Modification modification = ModificationChooser.this.modificationsFactory.getModification(modName);
                    return modification.getMass();
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

