/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.waiting.waitinghandlers;

import com.compomics.util.threading.SimpleSemaphore;
import com.compomics.util.waiting.WaitingHandler;
import java.util.Date;

public class WaitingHandlerCLIImpl
implements WaitingHandler {
    private boolean runFinished = false;
    private boolean runCanceled = false;
    private boolean displayProgress = true;
    private int primaryProgressCounter = 0;
    private int secondaryProgressCounter = 0;
    private int primaryMaxProgressCounter = 0;
    private int secondaryMaxProgressCounter = 0;
    protected String iReport = "";
    private boolean needNewLine = false;
    private final String lineBreak = System.getProperty("line.separator");
    private final SimpleSemaphore primaryMutex = new SimpleSemaphore(1);
    private final SimpleSemaphore secondaryMutex = new SimpleSemaphore(1);
    private final SimpleSemaphore progressMutex = new SimpleSemaphore(1);
    private final SimpleSemaphore textMutex = new SimpleSemaphore(1);

    @Override
    public void setMaxPrimaryProgressCounter(int maxProgressValue) {
        if (this.displayProgress) {
            this.primaryMutex.acquire();
            this.primaryMaxProgressCounter = maxProgressValue;
            this.primaryMutex.release();
        }
    }

    @Override
    public void increasePrimaryProgressCounter() {
        if (this.displayProgress) {
            this.increasePrimaryProgressCounter(1);
        }
    }

    @Override
    public void increasePrimaryProgressCounter(int value) {
        if (this.displayProgress) {
            this.primaryMutex.acquire();
            this.primaryProgressCounter += value;
            this.primaryMutex.release();
        }
    }

    @Override
    public void setPrimaryProgressCounter(int value) {
        if (this.displayProgress) {
            this.primaryMutex.acquire();
            this.primaryProgressCounter = value;
            this.primaryMutex.release();
        }
    }

    @Override
    public void setMaxSecondaryProgressCounter(int maxProgressValue) {
        if (this.displayProgress) {
            this.secondaryMutex.acquire();
            this.secondaryMaxProgressCounter = maxProgressValue;
            this.secondaryMutex.release();
        }
    }

    @Override
    public void resetSecondaryProgressCounter() {
        if (this.displayProgress) {
            this.setMaxSecondaryProgressCounter(0);
        }
    }

    @Override
    public void increaseSecondaryProgressCounter() {
        this.increaseSecondaryProgressCounter(1);
    }

    @Override
    public void setSecondaryProgressCounter(int value) {
        if (this.displayProgress) {
            if (this.secondaryMaxProgressCounter != 0) {
                this.secondaryMutex.acquire();
                int progress1 = 10 * this.secondaryProgressCounter / this.secondaryMaxProgressCounter;
                this.secondaryProgressCounter = value;
                int progress2 = 10 * this.secondaryProgressCounter / this.secondaryMaxProgressCounter;
                this.secondaryMutex.release();
                this.printProgress(progress1, progress2);
            } else {
                this.secondaryMutex.acquire();
                this.secondaryProgressCounter = value;
                this.secondaryMutex.release();
            }
        }
    }

    @Override
    public void increaseSecondaryProgressCounter(int value) {
        if (this.displayProgress) {
            if (this.secondaryMaxProgressCounter != 0) {
                this.secondaryMutex.acquire();
                int progress1 = 10 * this.secondaryProgressCounter / this.secondaryMaxProgressCounter;
                this.secondaryProgressCounter += value;
                int progress2 = 10 * this.secondaryProgressCounter / this.secondaryMaxProgressCounter;
                this.secondaryMutex.release();
                this.printProgress(progress1, progress2);
            } else {
                this.secondaryMutex.acquire();
                this.secondaryProgressCounter += value;
                this.secondaryMutex.release();
            }
        }
    }

    private void printProgress(int progress1, int progress2) {
        if (progress2 > progress1) {
            this.progressMutex.acquire();
            int progress = 10 * progress2;
            if (progress1 == 0) {
                if (this.needNewLine) {
                    System.out.append(this.lineBreak);
                }
                System.out.print("10%");
                this.needNewLine = true;
            } else if (progress2 > 99) {
                System.out.print(" " + progress + "%");
                System.out.append(this.lineBreak);
                this.needNewLine = false;
            } else {
                System.out.print(" " + progress + "%");
                this.needNewLine = true;
            }
            this.progressMutex.release();
        }
    }

    @Override
    public void setSecondaryProgressCounterIndeterminate(boolean indeterminate) {
        if (this.displayProgress) {
            this.secondaryProgressCounter = -1;
        }
    }

    @Override
    public void setRunFinished() {
        this.runFinished = true;
    }

    @Override
    public void setRunCanceled() {
        this.runCanceled = true;
    }

    @Override
    public void appendReport(String report, boolean includeDate, boolean addNewLine) {
        if (this.displayProgress) {
            String tempReport = report;
            if (includeDate) {
                Date date = new Date();
                tempReport = date + " " + report;
            }
            if (addNewLine) {
                tempReport = tempReport + this.lineBreak;
            }
            this.textMutex.acquire();
            this.iReport = this.iReport + tempReport;
            this.textMutex.release();
            if (this.needNewLine) {
                System.out.append(this.lineBreak);
                this.needNewLine = false;
            }
            System.out.append(tempReport);
        }
    }

    @Override
    public void appendReportNewLineNoDate() {
        if (this.displayProgress) {
            if (this.needNewLine) {
                System.out.append(this.lineBreak);
                this.needNewLine = false;
            }
            this.textMutex.acquire();
            this.iReport = this.iReport + this.lineBreak;
            this.textMutex.release();
            System.out.append(this.lineBreak);
        }
    }

    @Override
    public void appendReportEndLine() {
        if (this.displayProgress) {
            if (this.needNewLine) {
                System.out.append(this.lineBreak);
                this.needNewLine = false;
            }
            this.textMutex.acquire();
            this.iReport = this.iReport + this.lineBreak;
            this.textMutex.release();
            System.out.append(this.lineBreak);
        }
    }

    @Override
    public boolean isRunCanceled() {
        return this.runCanceled;
    }

    @Override
    public boolean isRunFinished() {
        return this.runFinished;
    }

    @Override
    public void setWaitingText(String text) {
        if (this.displayProgress) {
            this.appendReport(text, true, true);
        }
    }

    @Override
    public void setPrimaryProgressCounterIndeterminate(boolean indeterminate) {
        if (this.displayProgress && indeterminate) {
            this.primaryProgressCounter = -1;
        }
    }

    @Override
    public boolean isReport() {
        return true;
    }

    @Override
    public void setSecondaryProgressText(String text) {
        if (this.displayProgress) {
            this.appendReport(text, true, true);
        }
    }

    @Override
    public void resetPrimaryProgressCounter() {
        if (this.displayProgress) {
            this.primaryProgressCounter = 0;
        }
    }

    @Override
    public int getPrimaryProgressCounter() {
        return this.primaryProgressCounter;
    }

    @Override
    public int getMaxPrimaryProgressCounter() {
        return this.primaryMaxProgressCounter;
    }

    @Override
    public int getSecondaryProgressCounter() {
        return this.secondaryProgressCounter;
    }

    @Override
    public int getMaxSecondaryProgressCounter() {
        return this.secondaryMaxProgressCounter;
    }

    @Override
    public void setDisplayProgress(boolean displayProgress) {
        this.displayProgress = displayProgress;
    }

    @Override
    public boolean getDisplayProgress() {
        return this.displayProgress;
    }
}

