/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.export;

import com.compomics.util.io.export.ExportFormat;
import com.compomics.util.io.export.WorkbookStyle;
import com.compomics.util.io.export.writers.ExcelWriter;
import com.compomics.util.io.export.writers.TextWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class ExportWriter {
    public static final String LAST_FOLDER_KEY = "export";
    protected ExportFormat exportFormat;

    public ExportFormat getExportFormat() {
        return this.exportFormat;
    }

    public void write(String text) throws IOException {
        if (text == null) {
            text = "";
        }
        this.write(text, null);
    }

    public abstract void write(String var1, WorkbookStyle var2) throws IOException;

    public void writeMainTitle(String text) throws IOException {
        this.writeMainTitle(text, null);
    }

    public abstract void writeMainTitle(String var1, WorkbookStyle var2) throws IOException;

    public void startNewSection() throws IOException {
        this.startNewSection(null, null);
    }

    public void startNewSection(String sectionTitle) throws IOException {
        this.startNewSection(sectionTitle, null);
    }

    public abstract void startNewSection(String var1, WorkbookStyle var2) throws IOException;

    public void writeHeaderText(String text) throws IOException {
        this.writeHeaderText(text, null);
    }

    public abstract void writeHeaderText(String var1, WorkbookStyle var2) throws IOException;

    public void addSeparator() throws IOException {
        this.addSeparator(null);
    }

    public abstract void addSeparator(WorkbookStyle var1) throws IOException;

    public abstract void newLine() throws IOException;

    public abstract void close() throws IOException, FileNotFoundException;

    public abstract void increaseDepth();

    public abstract void decreaseDepth();

    public static ExportWriter getExportWriter(ExportFormat exportFormat, File destinationFile, String separator, int nSeparationLines, boolean gzip) throws IOException {
        switch (exportFormat) {
            case excel: {
                return new ExcelWriter(destinationFile);
            }
            case text: {
                return new TextWriter(destinationFile, separator, nSeparationLines, gzip);
            }
        }
        throw new IllegalArgumentException("No exporter implemented for format " + exportFormat.name + ".");
    }
}

