/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.export.features.reporter;

import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.features.ReporterExportFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPeptideFeature;
import com.compomics.util.io.export.features.reporter.ReporterPsmFeatures;
import java.util.ArrayList;
import java.util.Arrays;

public enum ReporterPeptideFeature implements ReporterExportFeature
{
    raw_ratio("Raw Ratios", "The ratios of this peptide prior to normalization.", true, true),
    spread("Spread", "The spread of the PSM ratios of this peptide.", true, false),
    normalized_ratio("Normalized Ratios", "The normalized ratios of this peptide.", true, false);

    public String title;
    public String description;
    private boolean hasChannels;
    public static final String type = "Peptide Reporter Quantification Summary";
    private final boolean advanced;

    private ReporterPeptideFeature(String title, String description, boolean hasChannels, boolean advanced) {
        this.title = title;
        this.description = description;
        this.hasChannels = hasChannels;
        this.advanced = advanced;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFeatureFamily() {
        return type;
    }

    @Override
    public ArrayList<ExportFeature> getExportFeatures(boolean includeSubFeatures) {
        ArrayList<ExportFeature> result = PsPeptideFeature.values()[0].getExportFeatures(includeSubFeatures);
        result.addAll(Arrays.asList(ReporterPeptideFeature.values()));
        if (includeSubFeatures) {
            result.addAll(ReporterPsmFeatures.values()[0].getExportFeatures(includeSubFeatures));
        }
        return result;
    }

    @Override
    public boolean hasChannels() {
        return this.hasChannels;
    }

    @Override
    public boolean isAdvanced() {
        return this.advanced;
    }
}

