/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.export.features.reporter;

import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.features.ReporterExportFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPsmFeature;
import java.util.ArrayList;
import java.util.Arrays;

public enum ReporterPsmFeatures implements ReporterExportFeature
{
    reporter_mz("Reporter m/z", "The reporter ions m/z as extracted from the spectrum.", true, true),
    reporter_intensity("Reporter Intensity", "The reporter ions instensities as extracted from the spectrum.", true, true),
    deisotoped_intensity("Deisotoped Intensity", "The instensities after deisotoping.", true, true),
    raw_ratio("Raw Ratios", "The ratios of this PSM prior to normalization.", true, false),
    ratio("Ratios", "The normalized ratios of this PSM.", true, false);

    public String title;
    public String description;
    private boolean hasChannels;
    public static final String type = "PSM Reporter Quantification Summary";
    private final boolean advanced;

    private ReporterPsmFeatures(String title, String description, boolean hasChannels, boolean advanced) {
        this.title = title;
        this.description = description;
        this.hasChannels = hasChannels;
        this.advanced = advanced;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFeatureFamily() {
        return type;
    }

    @Override
    public ArrayList<ExportFeature> getExportFeatures(boolean includeSubFeatures) {
        ArrayList<ExportFeature> result = PsPsmFeature.values()[0].getExportFeatures(includeSubFeatures);
        result.addAll(Arrays.asList(ReporterPsmFeatures.values()));
        return result;
    }

    @Override
    public boolean hasChannels() {
        return this.hasChannels;
    }

    @Override
    public boolean isAdvanced() {
        return this.advanced;
    }
}

