/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.file;

import com.compomics.util.interfaces.Monitorable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorableInputStream
extends FilterInputStream
implements Monitorable {
    Logger logger = LogManager.getLogger(MonitorableInputStream.class);
    private int iMaximum = 0;
    private int iRemainder = this.iMaximum = this.available();
    private boolean iMaxSet = false;
    private boolean iBypassCache = false;

    public MonitorableInputStream(InputStream aIn) throws IOException {
        this(aIn, false);
    }

    public MonitorableInputStream(InputStream aIn, int aMaximum) throws IOException {
        this(aIn, false);
        this.iMaxSet = true;
    }

    public MonitorableInputStream(InputStream aIn, boolean aBypassCache) throws IOException {
        super(aIn);
        this.iBypassCache = aBypassCache;
    }

    @Override
    public int getMaximum() {
        return this.iMaximum;
    }

    @Override
    public int monitorProgress() {
        int result = 0;
        if (this.iBypassCache) {
            try {
                result = this.iMaximum - this.available();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failure when monitoring real-time read progress!");
            }
        } else {
            result = this.iMaximum - this.iRemainder;
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = super.read(b);
        if (this.iMaxSet) {
            if (result >= 0) {
                this.iRemainder -= result;
            }
        } else {
            this.iRemainder = this.available();
        }
        return result;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        this.iRemainder = this.iMaxSet ? --this.iRemainder : this.available();
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (this.iMaxSet) {
            if (result >= 0) {
                this.iRemainder -= result;
            }
        } else {
            this.iRemainder = this.available();
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = super.skip(n);
        this.iRemainder = this.iMaxSet ? (this.iRemainder -= (int)n) : this.available();
        return result;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        if (!this.iMaxSet) {
            this.iMaximum = this.available();
        }
        this.iRemainder = this.iMaximum;
    }
}

