/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.flat.readers;

import com.compomics.util.io.flat.SimpleFileReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.input.CountingInputStream;

public class SimpleTextReader
implements SimpleFileReader {
    private final BufferedReader br;
    private final long fileLength;
    private final CountingInputStream countingInputStream;

    public SimpleTextReader(File file) {
        try {
            FileInputStream fileStream = new FileInputStream(file);
            this.countingInputStream = new CountingInputStream((InputStream)fileStream);
            InputStreamReader reader = new InputStreamReader((InputStream)this.countingInputStream, "UTF-8");
            this.br = new BufferedReader(reader);
            this.fileLength = file.length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String readLine() {
        try {
            return this.br.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.br.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Reader getReader() {
        return this.br;
    }

    @Override
    public double getProgressInPercent() {
        return 100.0 * (double)this.countingInputStream.getByteCount() / (double)this.fileLength;
    }

    @Override
    public int read(char[] buffer) {
        try {
            return this.br.read(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int read(char[] buffer, int offset, int length) {
        try {
            return this.br.read(buffer, offset, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

