/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math.statistics.distributions;

import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.math.statistics.Distribution;
import com.compomics.util.math.statistics.distributions.NormalDistribution;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class NonSymmetricalNormalDistribution
extends ExperimentObject
implements Distribution {
    static final long serialVersionUID = -5258258835569357886L;
    private final double stdUp;
    private final double stdDown;
    private final double mean;
    private final NormalDistribution distributionUp;
    private final NormalDistribution distributionDown;

    public NonSymmetricalNormalDistribution() {
        this.stdUp = 0.0;
        this.stdDown = 0.0;
        this.mean = 0.0;
        this.distributionUp = null;
        this.distributionDown = null;
    }

    public NonSymmetricalNormalDistribution(double mean, double stdDown, double stdUp) {
        this.mean = mean;
        this.stdDown = stdDown;
        this.stdUp = stdUp;
        this.distributionDown = new NormalDistribution(mean, stdDown);
        this.distributionUp = new NormalDistribution(mean, stdUp);
    }

    public double getStdUp() {
        return this.stdUp;
    }

    public double getStdDown() {
        return this.stdDown;
    }

    public double getMean() {
        return this.mean;
    }

    public static NonSymmetricalNormalDistribution getRobustNonSymmetricalNormalDistribution(ArrayList<Double> input) {
        ArrayList sortedInput = input.stream().sorted().collect(Collectors.toCollection(ArrayList::new));
        return NonSymmetricalNormalDistribution.getRobustNonSymmetricalNormalDistributionFromSortedList(sortedInput);
    }

    public static NonSymmetricalNormalDistribution getRobustNonSymmetricalNormalDistributionFromSortedList(ArrayList<Double> input) {
        double median = BasicMathFunctions.medianSorted(input);
        double percentileDown = BasicMathFunctions.percentileSorted(input, 0.159);
        double percentileUp = BasicMathFunctions.percentileSorted(input, 0.841);
        return new NonSymmetricalNormalDistribution(median, median - percentileDown, percentileUp - median);
    }

    public static NonSymmetricalNormalDistribution getRobustNonSymmetricalNormalDistributionFromSortedArray(double[] input) {
        double median = BasicMathFunctions.median(input);
        double percentileDown = BasicMathFunctions.percentileSorted(input, 0.159);
        double percentileUp = BasicMathFunctions.percentileSorted(input, 0.841);
        return new NonSymmetricalNormalDistribution(median, median - percentileDown, percentileUp - median);
    }

    @Override
    public double getProbabilityAt(double x) {
        return x >= this.mean ? this.distributionUp.getProbabilityAt(x) : this.distributionDown.getProbabilityAt(x);
    }

    @Override
    public double getCumulativeProbabilityAt(double x) {
        return x >= this.mean ? this.distributionUp.getCumulativeProbabilityAt(x) : this.distributionDown.getCumulativeProbabilityAt(x);
    }

    @Override
    public double getDescendingCumulativeProbabilityAt(double x) {
        return x > this.mean ? this.distributionUp.getDescendingCumulativeProbabilityAt(x) : this.distributionDown.getDescendingCumulativeProbabilityAt(x);
    }

    @Override
    public double getSmallestCumulativeProbabilityAt(double x) {
        return x > this.mean ? this.getDescendingCumulativeProbabilityAt(x) : this.getCumulativeProbabilityAt(x);
    }

    @Override
    public double getMaxValueForProbability(double p) {
        return this.distributionUp.getMaxValueForProbability(p);
    }

    @Override
    public double getMinValueForProbability(double p) {
        return this.distributionDown.getMinValueForProbability(p);
    }

    @Override
    public double getValueAtCumulativeProbability(double p) {
        return p < 0.5 ? this.distributionDown.getValueAtCumulativeProbability(p) : this.distributionUp.getValueAtCumulativeProbability(p);
    }

    @Override
    public double getValueAtDescendingCumulativeProbability(double p) {
        return p < 0.5 ? this.distributionUp.getValueAtDescendingCumulativeProbability(p) : this.distributionDown.getValueAtDescendingCumulativeProbability(p);
    }
}

