/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math.statistics.distributions;

import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.math.statistics.Distribution;
import java.util.ArrayList;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistributionImpl;

public class NormalDistribution
extends ExperimentObject
implements Distribution {
    private NormalDistributionImpl normalDistributionImpl;
    private final double mean;
    private final double std;

    public NormalDistribution() {
        this.mean = 0.0;
        this.std = 0.0;
    }

    public NormalDistribution(double mean, double std) {
        this.mean = mean;
        this.std = std;
        if (std > 0.0) {
            this.normalDistributionImpl = new NormalDistributionImpl(mean, std);
        }
    }

    public static NormalDistribution getNormalDistribution(ArrayList<Double> input) {
        return new NormalDistribution(BasicMathFunctions.mean(input), BasicMathFunctions.std(input));
    }

    public static NormalDistribution getRobustNormalDistribution(ArrayList<Double> input) {
        double std = (BasicMathFunctions.percentile(input, 0.841) - BasicMathFunctions.percentile(input, 0.159)) / 2.0;
        return new NormalDistribution(BasicMathFunctions.median(input), std);
    }

    @Override
    public double getProbabilityAt(double x) {
        if (this.std > 0.0) {
            double xNorm = (x - this.mean) / this.std;
            return Math.pow(Math.E, -Math.pow(xNorm, 2.0) / 2.0) / Math.pow(Math.PI * 2, 0.5);
        }
        if (this.std == 0.0) {
            if (x == this.mean) {
                return 1.0;
            }
            return 0.0;
        }
        throw new IllegalArgumentException("std < 0");
    }

    @Override
    public double getMaxValueForProbability(double p) {
        if (this.std > 0.0) {
            if (p >= 1.0) {
                throw new IllegalArgumentException("Probability >= 1");
            }
            if (p <= 0.0) {
                throw new IllegalArgumentException("Probability <= 0");
            }
            double x = Math.pow(-2.0 * Math.log(p * Math.pow(Math.PI * 2, 0.5)), 0.5);
            return this.mean + this.std * x;
        }
        if (this.std == 0.0) {
            return this.mean;
        }
        throw new IllegalArgumentException("std < 0");
    }

    @Override
    public double getMinValueForProbability(double p) {
        if (this.std > 0.0) {
            if (p >= 1.0) {
                throw new IllegalArgumentException("Probability >= 1");
            }
            if (p <= 0.0) {
                throw new IllegalArgumentException("Probability <= 0");
            }
            double x = Math.pow(-2.0 * Math.log(p * Math.pow(Math.PI * 2, 0.5)), 0.5);
            return this.mean - this.std * x;
        }
        if (this.std == 0.0) {
            return this.mean;
        }
        throw new IllegalArgumentException("std < 0");
    }

    @Override
    public double getCumulativeProbabilityAt(double x) {
        if (this.std > 0.0) {
            try {
                return this.normalDistributionImpl.cumulativeProbability(x);
            }
            catch (MathException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this.std == 0.0) {
            if (x < this.mean) {
                return 0.0;
            }
            if (x == this.mean) {
                return 0.5;
            }
            return 1.0;
        }
        throw new IllegalArgumentException("std < 0");
    }

    @Override
    public double getValueAtCumulativeProbability(double p) {
        if (this.std > 0.0) {
            try {
                return this.normalDistributionImpl.inverseCumulativeProbability(p);
            }
            catch (MathException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this.std == 0.0) {
            if (p < 0.5) {
                return Double.NEGATIVE_INFINITY;
            }
            if (p == 0.5) {
                return this.mean;
            }
            return Double.POSITIVE_INFINITY;
        }
        throw new IllegalArgumentException("std < 0");
    }

    @Override
    public double getDescendingCumulativeProbabilityAt(double x) {
        if (this.std > 0.0) {
            return 1.0 - this.getCumulativeProbabilityAt(x);
        }
        if (this.std == 0.0) {
            if (x > this.mean) {
                return 0.0;
            }
            if (x == this.mean) {
                return 0.5;
            }
            return 1.0;
        }
        throw new IllegalArgumentException("std < 0");
    }

    @Override
    public double getSmallestCumulativeProbabilityAt(double x) {
        return x > this.mean ? this.getDescendingCumulativeProbabilityAt(x) : this.getCumulativeProbabilityAt(x);
    }

    @Override
    public double getValueAtDescendingCumulativeProbability(double p) {
        if (this.std > 0.0) {
            return this.getValueAtCumulativeProbability(1.0 - p);
        }
        if (this.std == 0.0) {
            if (p < 0.5) {
                return Double.POSITIVE_INFINITY;
            }
            if (p == 0.5) {
                return this.mean;
            }
            return Double.NEGATIVE_INFINITY;
        }
        throw new IllegalArgumentException("std < 0");
    }
}

