/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.tool_specific;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;

public class XtandemParameters
extends ExperimentObject
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = -5898951075262732261L;
    private double maxEValue = 0.01;
    private String outputResults = "all";
    private double dynamicRange = 100.0;
    private int nPeaks = 50;
    private double minPrecursorMass = 500.0;
    private double minFragmentMz = 200.0;
    private int minPeaksPerSpectrum = 5;
    private boolean proteinQuickAcetyl = true;
    private boolean quickPyrolidone = true;
    private boolean refine = true;
    private boolean refineSemi = false;
    private boolean refinePointMutations = false;
    private boolean refineSpectrumSynthesis = true;
    private boolean refineUnanticipatedCleavages = true;
    private boolean refineSnaps = true;
    private double maximumExpectationValueRefinement = 0.01;
    private boolean potentialModificationsForFullRefinment = false;
    private String skylinePath = "";
    private boolean outputProteins = true;
    private boolean outputSequences = false;
    private boolean outputSpectra = true;
    private boolean outputHistograms = false;
    private boolean stpBias = false;
    private boolean useNoiseSuppression = false;
    private double proteinPtmComplexity = 6.0;
    private boolean parentMonoisotopicMassIsotopeError = true;

    public double getDynamicRange() {
        return this.dynamicRange;
    }

    public void setDynamicRange(double dynamicRange) {
        this.dynamicRange = dynamicRange;
    }

    public int getnPeaks() {
        return this.nPeaks;
    }

    public void setnPeaks(int nPeaks) {
        this.nPeaks = nPeaks;
    }

    public double getMinPrecursorMass() {
        return this.minPrecursorMass;
    }

    public void setMinPrecursorMass(double minPrecursorMass) {
        this.minPrecursorMass = minPrecursorMass;
    }

    public double getMinFragmentMz() {
        return this.minFragmentMz;
    }

    public void setMinFragmentMz(double minFragmentMz) {
        this.minFragmentMz = minFragmentMz;
    }

    public int getMinPeaksPerSpectrum() {
        return this.minPeaksPerSpectrum;
    }

    public void setMinPeaksPerSpectrum(int minPeaksPerSpectrum) {
        this.minPeaksPerSpectrum = minPeaksPerSpectrum;
    }

    public boolean isProteinQuickAcetyl() {
        return this.proteinQuickAcetyl;
    }

    public void setProteinQuickAcetyl(boolean proteinQuickAcetyl) {
        this.proteinQuickAcetyl = proteinQuickAcetyl;
    }

    public boolean isQuickPyrolidone() {
        return this.quickPyrolidone;
    }

    public void setQuickPyrolidone(boolean quickPyrolidone) {
        this.quickPyrolidone = quickPyrolidone;
    }

    public boolean isRefine() {
        return this.refine;
    }

    public void setRefine(boolean refine) {
        this.refine = refine;
    }

    public boolean isStpBias() {
        return this.stpBias;
    }

    public void setStpBias(boolean stpBias) {
        this.stpBias = stpBias;
    }

    public double getMaxEValue() {
        return this.maxEValue;
    }

    public void setMaxEValue(double maxEValue) {
        this.maxEValue = maxEValue;
    }

    public boolean isRefineSemi() {
        return this.refineSemi;
    }

    public void setRefineSemi(boolean refineSemi) {
        this.refineSemi = refineSemi;
    }

    public boolean isRefinePointMutations() {
        return this.refinePointMutations;
    }

    public void setRefinePointMutations(boolean refinePointMutations) {
        this.refinePointMutations = refinePointMutations;
    }

    public boolean isRefineSpectrumSynthesis() {
        return this.refineSpectrumSynthesis;
    }

    public void setRefineSpectrumSynthesis(boolean refineSpectrumSynthesis) {
        this.refineSpectrumSynthesis = refineSpectrumSynthesis;
    }

    public boolean isRefineUnanticipatedCleavages() {
        return this.refineUnanticipatedCleavages;
    }

    public void setRefineUnanticipatedCleavages(boolean refineUnanticipatedCleavages) {
        this.refineUnanticipatedCleavages = refineUnanticipatedCleavages;
    }

    public double getMaximumExpectationValueRefinement() {
        return this.maximumExpectationValueRefinement;
    }

    public void setMaximumExpectationValueRefinement(double maximumExpectationValue) {
        this.maximumExpectationValueRefinement = maximumExpectationValue;
    }

    public boolean isPotentialModificationsForFullRefinment() {
        return this.potentialModificationsForFullRefinment;
    }

    public void setPotentialModificationsForFullRefinment(boolean potentialModificationsForFullRefinment) {
        this.potentialModificationsForFullRefinment = potentialModificationsForFullRefinment;
    }

    public String getSkylinePath() {
        return this.skylinePath;
    }

    public void setSkylinePath(String skylinePath) {
        this.skylinePath = skylinePath;
    }

    public boolean isOutputProteins() {
        return this.outputProteins;
    }

    public void setOutputProteins(boolean outputProteins) {
        this.outputProteins = outputProteins;
    }

    public boolean isOutputSequences() {
        return this.outputSequences;
    }

    public void setOutputSequences(boolean outputSequences) {
        this.outputSequences = outputSequences;
    }

    public boolean isOutputSpectra() {
        return this.outputSpectra;
    }

    public void setOutputSpectra(boolean outputSpectra) {
        this.outputSpectra = outputSpectra;
    }

    public boolean isOutputHistograms() {
        return this.outputHistograms;
    }

    public void setOutputHistograms(boolean outputHistograms) {
        this.outputHistograms = outputHistograms;
    }

    public boolean isUseNoiseSuppression() {
        return this.useNoiseSuppression;
    }

    public void setUseNoiseSuppression(boolean useNoiseSuppression) {
        this.useNoiseSuppression = useNoiseSuppression;
    }

    public boolean isRefineSnaps() {
        return this.refineSnaps;
    }

    public void setRefineSnaps(boolean refineSnaps) {
        this.refineSnaps = refineSnaps;
    }

    public String getOutputResults() {
        return this.outputResults;
    }

    public void setOutputResults(String outputResults) {
        this.outputResults = outputResults;
    }

    public double getProteinPtmComplexity() {
        return this.proteinPtmComplexity;
    }

    public void setProteinPtmComplexity(double proteinPtmComplexity) {
        this.proteinPtmComplexity = proteinPtmComplexity;
    }

    @Override
    public Advocate getAlgorithm() {
        return Advocate.xtandem;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof XtandemParameters) {
            XtandemParameters xtandemParameters = (XtandemParameters)identificationAlgorithmParameter;
            if (this.maxEValue != xtandemParameters.getMaxEValue()) {
                return false;
            }
            if (this.dynamicRange != xtandemParameters.getDynamicRange()) {
                return false;
            }
            if (this.getnPeaks() != xtandemParameters.getnPeaks()) {
                return false;
            }
            if (this.minPrecursorMass != xtandemParameters.getMinPrecursorMass()) {
                return false;
            }
            if (this.minFragmentMz != xtandemParameters.getMinFragmentMz()) {
                return false;
            }
            if (this.getMinPeaksPerSpectrum() != xtandemParameters.getMinPeaksPerSpectrum()) {
                return false;
            }
            if (this.isProteinQuickAcetyl() != xtandemParameters.isProteinQuickAcetyl()) {
                return false;
            }
            if (this.isQuickPyrolidone() != xtandemParameters.isQuickPyrolidone()) {
                return false;
            }
            if (this.isRefine() != xtandemParameters.isRefine()) {
                return false;
            }
            if (this.isRefineSemi() != xtandemParameters.isRefineSemi()) {
                return false;
            }
            if (this.isRefinePointMutations() != xtandemParameters.isRefinePointMutations()) {
                return false;
            }
            if (this.isRefineSpectrumSynthesis() != xtandemParameters.isRefineSpectrumSynthesis()) {
                return false;
            }
            if (this.isRefineUnanticipatedCleavages() != xtandemParameters.isRefineUnanticipatedCleavages()) {
                return false;
            }
            if (this.isRefineSnaps() != xtandemParameters.isRefineSnaps()) {
                return false;
            }
            if (this.maximumExpectationValueRefinement != xtandemParameters.getMaximumExpectationValueRefinement()) {
                return false;
            }
            if (this.isPotentialModificationsForFullRefinment() != xtandemParameters.isPotentialModificationsForFullRefinment()) {
                return false;
            }
            if (!this.getSkylinePath().equals(xtandemParameters.getSkylinePath())) {
                return false;
            }
            if (this.isOutputProteins() != xtandemParameters.isOutputProteins()) {
                return false;
            }
            if (this.isOutputSpectra() != xtandemParameters.isOutputSpectra()) {
                return false;
            }
            if (this.isOutputSequences() != xtandemParameters.isOutputSequences()) {
                return false;
            }
            if (this.isOutputHistograms() != xtandemParameters.isOutputHistograms()) {
                return false;
            }
            if (this.isStpBias() != xtandemParameters.isStpBias()) {
                return false;
            }
            if (this.isUseNoiseSuppression() != xtandemParameters.isUseNoiseSuppression()) {
                return false;
            }
            if (!this.getOutputResults().equalsIgnoreCase(xtandemParameters.getOutputResults())) {
                return false;
            }
            if (this.getProteinPtmComplexity() != xtandemParameters.getProteinPtmComplexity()) {
                return false;
            }
            return this.getParentMonoisotopicMassIsotopeError() == xtandemParameters.getParentMonoisotopicMassIsotopeError();
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("DYNAMIC_RANGE=");
        output.append(this.dynamicRange);
        output.append(newLine);
        output.append("NUMBER_OF_PEAKS=");
        output.append(this.nPeaks);
        output.append(newLine);
        output.append("MIN_FRAG_MASS=");
        output.append(this.minFragmentMz);
        output.append(newLine);
        output.append("MIN_NUMBER_OF_PEAKS=");
        output.append(this.minPeaksPerSpectrum);
        output.append(newLine);
        output.append("NOISE_SUPPRESSION=");
        if (this.useNoiseSuppression) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("PARENT_MONOISOTOPIC_MASS_ISOTOPE_ERROR=");
        if (this.parentMonoisotopicMassIsotopeError) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("MIN_PREC_MASS=");
        output.append(this.minPrecursorMass);
        output.append(newLine);
        output.append("PROTEIN_QUICK_ACETYL=");
        if (this.proteinQuickAcetyl) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("QUICK_PYROLIDONE=");
        if (this.quickPyrolidone) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("PROTEIN_PTM_COMPLEXITY=");
        output.append(this.getProteinPtmComplexity());
        output.append(newLine);
        output.append("STP_BIAS=");
        if (this.stpBias) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("REFINE=");
        if (this.refine) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("REFINE_SEMI=");
        if (this.refineSemi) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("REFINE_POINT_MUTATIONS=");
        if (this.refinePointMutations) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("REFINE_SPECTRUM_SYNTHESIS=");
        if (this.refineSpectrumSynthesis) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("REFINE_UNANTICIPATED_CLEABAGES=");
        if (this.refineUnanticipatedCleavages) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("REFINE_SNAPS=");
        if (this.refineSnaps) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("REFINE_MAX_EVALUE=");
        output.append(this.maximumExpectationValueRefinement);
        output.append(newLine);
        output.append("POTENTIAL_MODIFICATIONS_FOR_FULL_REFINEMENT=");
        if (this.potentialModificationsForFullRefinment) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("EVALUE_CUTOFF=");
        output.append(this.maxEValue);
        output.append(newLine);
        output.append("SKYLINE_PATH=");
        output.append(this.skylinePath);
        output.append(newLine);
        output.append("OUTPUT_RESULTS=");
        output.append(this.getOutputResults());
        output.append(newLine);
        output.append("OUTPUT_PROTEINS=");
        if (this.outputProteins) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("OUTPUT_SEQUENCES=");
        if (this.outputSequences) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("OUTPUT_SPECTRA=");
        if (this.outputSpectra) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        output.append("OUTPUT_HISTOGRAMS=");
        if (this.outputHistograms) {
            output.append("YES");
        } else {
            output.append("NO");
        }
        output.append(newLine);
        return output.toString();
    }

    public boolean getParentMonoisotopicMassIsotopeError() {
        return this.parentMonoisotopicMassIsotopeError;
    }

    public void setParentMonoisotopicMassIsotopeError(boolean parentMonoisotopicMassIsotopeError) {
        this.parentMonoisotopicMassIsotopeError = parentMonoisotopicMassIsotopeError;
    }
}

