/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.peptide_shaker;

public enum ProjectType {
    psm(0, "psm", "PSM level project."),
    peptide(1, "peptide", "Peptide level project"),
    protein(2, "protein", "Protein level project");

    public final int index;
    public final String name;
    public final String description;

    private ProjectType(int index, String name, String description) {
        this.index = index;
        this.name = name;
        this.description = description;
    }

    private ProjectType() {
        this.index = 0;
        this.name = "";
        this.description = "";
    }

    public static String[] getGuiOptions() {
        return new String[]{"Protein", "Peptide", "PSM"};
    }

    public static ProjectType getProjectType(String guiOption) {
        switch (guiOption) {
            case "Protein": {
                return protein;
            }
            case "Peptide": {
                return peptide;
            }
            case "PSM": {
                return psm;
            }
        }
        throw new IllegalArgumentException("Option " + guiOption + "not found.");
    }

    public static ProjectType getProjectType(int index) {
        for (ProjectType projectType : ProjectType.values()) {
            if (projectType.index != index) continue;
            return projectType;
        }
        throw new IllegalArgumentException("No project type found for option '" + index + "'. Available options are " + ProjectType.getCommandLineOptions());
    }

    public static String getCommandLineOptions() {
        return ProjectType.protein.index + ": " + ProjectType.protein.description + " (default), " + ProjectType.peptide.index + ": " + ProjectType.peptide.description + ", " + ProjectType.psm.index + ": " + ProjectType.psm.description + ".";
    }
}

