/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.searchgui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public enum OutputParameters {
    grouped(0, "Single Zip File", "Group all files in a single compressed zip folder"),
    run(1, "Zip File per Mgf", "Group files per run (i.e. spectrum file)"),
    algorithm(2, "Zip File per Algorithm", "Group files per identification algorithm"),
    no_zip(3, "No Zipping", "No file grouping");

    public final int id;
    public final String name;
    public final String description;

    private OutputParameters(int id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public static int[] getOutputOptions() {
        OutputParameters[] options = OutputParameters.values();
        int[] result = new int[options.length];
        int i = 0;
        for (OutputParameters outputOption : options) {
            result[i] = outputOption.id;
            ++i;
        }
        return result;
    }

    public static String[] getOutputParametersNames() {
        OutputParameters[] options = OutputParameters.values();
        String[] result = new String[options.length];
        int i = 0;
        for (OutputParameters outputOption : options) {
            result[i] = outputOption.name;
            ++i;
        }
        return result;
    }

    public static OutputParameters getOutputParameters(int id) {
        for (OutputParameters outputOption : OutputParameters.values()) {
            if (outputOption.id != id) continue;
            return outputOption;
        }
        return null;
    }

    public static String getCommandLineOptions() {
        OutputParameters[] values = OutputParameters.values();
        ArrayList<Integer> options = new ArrayList<Integer>(values.length);
        for (OutputParameters option : values) {
            options.add(option.id);
        }
        Collections.sort(options);
        StringBuilder commandLine = new StringBuilder();
        Iterator iterator = options.iterator();
        while (iterator.hasNext()) {
            int option = (Integer)iterator.next();
            if (commandLine.length() > 0) {
                commandLine.append(", ");
            }
            commandLine.append(option).append(": ").append(OutputParameters.getOutputParameters((int)option).description);
        }
        return commandLine.toString();
    }

    private OutputParameters() {
        this.id = 0;
        this.name = "";
        this.description = "";
    }
}

