/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein;

import com.compomics.util.experiment.io.biology.protein.Header;
import com.compomics.util.protein.AASequenceImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Protein {
    Logger logger = LogManager.getLogger(Protein.class);
    private AASequenceImpl iSequence = null;
    private Header iHeader = null;
    private boolean iTruncated = false;
    private int iTruncationPosition = 0;
    public static final int NTERMTRUNC = 1;
    public static final int CTERMTRUNC = 2;

    public Protein() {
    }

    public Protein(AASequenceImpl aSequence) {
        this(null, aSequence);
    }

    public Protein(Header aHeader, AASequenceImpl aSequence) {
        this(aHeader, aSequence, false, 0);
    }

    public Protein(Header aHeader, AASequenceImpl aSequence, boolean aTruncated, int aTruncationPosition) {
        this.iSequence = aSequence;
        this.iHeader = aHeader;
        this.iTruncated = aTruncated;
        this.iTruncationPosition = aTruncationPosition;
    }

    public Protein(String aFASTAString) {
        this(aFASTAString, false, 0);
    }

    public Protein(String aFASTAString, boolean aTruncated, int aTruncationPosition) {
        try {
            BufferedReader br = new BufferedReader(new StringReader(aFASTAString));
            this.iHeader = Header.parseFromFASTA(br.readLine());
            StringBuffer lSB = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                lSB.append(line);
            }
            this.iSequence = new AASequenceImpl(lSB.toString());
            this.iTruncated = aTruncated;
            this.iTruncationPosition = aTruncationPosition;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Unable to process your FASTA String ('" + aFASTAString + "'). IOException: " + ioe.getMessage() + ".");
        }
    }

    public Protein(String aHeader, String aSequence) {
        this(aHeader, aSequence, false, 0);
    }

    public Protein(String aHeader, String aSequence, boolean aTruncated, int aTruncationPosition) {
        this.iHeader = Header.parseFromFASTA(aHeader);
        this.iSequence = new AASequenceImpl(aSequence);
        this.iTruncated = aTruncated;
        this.iTruncationPosition = aTruncationPosition;
    }

    public Header getHeader() {
        return this.iHeader;
    }

    public AASequenceImpl getSequence() {
        return this.iSequence;
    }

    public Protein getNTermTruncatedProtein(int aSize) {
        AASequenceImpl sequence = this.getSequence();
        int start = this.getHeader().getStartLocation();
        if (start < 0) {
            start = 1;
        }
        sequence = sequence.getNTermTruncatedSequence(aSize);
        int end = start + sequence.getLength() - 1;
        Header header = (Header)this.getHeader().clone();
        header.setLocation(start, end);
        boolean flag = false;
        if (this.getLength() > (long)aSize) {
            flag = true;
        }
        return new Protein(header, sequence, flag, 1);
    }

    public Protein getCTermTruncatedProtein(int aSize) {
        AASequenceImpl sequence = this.getSequence();
        int end = this.getHeader().getEndLocation();
        if (end < 0) {
            end = sequence.getLength();
        }
        sequence = sequence.getCTermTruncatedSequence(aSize);
        int start = end - sequence.getLength() + 1;
        Header header = (Header)this.getHeader().clone();
        header.setLocation(start, end);
        boolean flag = false;
        if (this.getLength() > (long)aSize) {
            flag = true;
        }
        return new Protein(header, sequence, flag, 2);
    }

    public long getLength() {
        return this.getSequence().getLength();
    }

    public double getMass() {
        return this.getSequence().getMass();
    }

    public void setHeader(Header aHeader) {
        this.iHeader = aHeader;
    }

    public void setSequence(AASequenceImpl aSequence) {
        this.iSequence = aSequence;
    }

    public void writeToFASTAFile(PrintWriter aOut) throws IOException {
        aOut.println(this.getHeader().getAbbreviatedFASTAHeaderWithAddenda());
        StringBuffer sequence = new StringBuffer(this.getSequence().getSequence());
        if (sequence.length() > 59) {
            int offset = 58;
            do {
                sequence.insert(offset, "\n");
            } while ((offset += 59) <= sequence.length());
        }
        aOut.println(sequence.toString());
    }

    public boolean isTruncated() {
        return this.iTruncated;
    }

    public int getTruncationPosition() {
        return this.iTruncationPosition;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof Protein) {
            Protein p = (Protein)o;
            if (p.iHeader.getFullHeaderWithAddenda().equals(this.iHeader.getFullHeaderWithAddenda()) && p.iSequence.getModifiedSequence().equals(this.iSequence.getModifiedSequence()) && p.iTruncated == this.iTruncated && p.iTruncationPosition == this.iTruncationPosition) {
                result = true;
            }
        }
        return result;
    }
}

