/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.unicode.decoder;

import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStreamException;
import info.monitorenter.cpdetector.util.FileUtil;
import info.monitorenter.unicode.decoder.html.HtmlEntityDecoder;
import info.monitorenter.unicode.decoder.html.HtmlEntityLexer;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;

public final class DecodeUtil {
    private DecodeUtil() {
    }

    public static String decodeHtmlEntities(String html, boolean recursive) throws RecognitionException, TokenStreamException, IOException {
        HtmlEntityDecoder decoder;
        String result = html;
        boolean again = false;
        do {
            StringBuffer resultBuffer = new StringBuffer();
            HtmlEntityLexer lexer = new HtmlEntityLexer(new StringReader(result));
            decoder = new HtmlEntityDecoder(lexer);
            Token token = decoder.decodeNext();
            while (token.getType() != 1) {
                resultBuffer.append(token.getText());
                token = decoder.decodeNext();
            }
            result = resultBuffer.toString();
        } while ((again = decoder.isPotentialRemainingEntity()) && recursive);
        return result;
    }

    public static void main(String[] args) throws RecognitionException, TokenStreamException, IOException, CmdLineParser.IllegalOptionValueException, CmdLineParser.UnknownOptionException {
        try {
            File outputFile;
            File inputFile;
            CmdLineParser cmdLineParser = new CmdLineParser();
            CmdLineParser.Option charsetOption = cmdLineParser.addStringOption('c', "charset");
            cmdLineParser.parse(args);
            String encoding = (String)cmdLineParser.getOptionValue(charsetOption);
            String[] remainingArgs = cmdLineParser.getRemainingArgs();
            if (remainingArgs.length != 2) {
                DecodeUtil.printUsage("Input and output file are not specified correctly. ");
            }
            if (!(inputFile = new File(remainingArgs[0])).exists()) {
                DecodeUtil.printUsage("Input file " + remainingArgs[0] + " does not exist. ");
            }
            if (!(outputFile = new File(remainingArgs[1])).exists()) {
                outputFile.createNewFile();
            }
            String input = new String(FileUtil.readRAM(inputFile), encoding);
            String result = DecodeUtil.decodeHtmlEntities(input, true);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding);
            out.write(result);
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            DecodeUtil.printUsage(ex.getMessage());
        }
    }

    private static void printUsage(String errmsg) throws IllegalArgumentException {
        StringBuffer msg = new StringBuffer("java -jar htmlentitydecoder.jar <options> infile outfile\n");
        msg.append("  options: \n");
        msg.append("    -c [--charset] : The charset to use for reading / writing.\n");
        msg.append(errmsg);
        throw new IllegalArgumentException(msg.toString());
    }
}

