/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.unicode.decoder.html;

import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStreamException;
import info.monitorenter.unicode.decoder.html.HtmlEntityDecoder;
import info.monitorenter.unicode.decoder.html.HtmlEntityLexer;
import java.io.IOException;
import java.io.Reader;

public class HtmlEntityDecoderReader
extends Reader {
    private Reader m_decorated;
    private char[] m_lastTokenRemainder;
    private HtmlEntityDecoder m_parser;

    public HtmlEntityDecoderReader(Reader decorate) {
        this.m_decorated = decorate;
        HtmlEntityLexer lexer = new HtmlEntityLexer(decorate);
        this.m_parser = new HtmlEntityDecoder(lexer);
    }

    public void close() throws IOException {
        this.m_decorated.close();
        this.m_parser.getInputState().reset();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int result = 0;
        int targetIndex = off;
        if (this.m_lastTokenRemainder != null) {
            while (result < len && result < this.m_lastTokenRemainder.length) {
                cbuf[targetIndex] = this.m_lastTokenRemainder[result];
                ++result;
                ++targetIndex;
            }
        }
        try {
            Token token = this.m_parser.decodeNext();
            while (result < len && token.getType() != 1) {
                if (token.getType() == 1) {
                    this.m_lastTokenRemainder = new char[0];
                } else {
                    char[] text = token.getText().toCharArray();
                    int tokenIndex = 0;
                    while (tokenIndex < text.length && result < len) {
                        cbuf[targetIndex] = text[tokenIndex];
                        ++tokenIndex;
                        ++result;
                        ++targetIndex;
                    }
                    if (result == len && text.length > tokenIndex) {
                        char[] tail = new char[text.length - tokenIndex];
                        int i = 0;
                        while (i < tail.length) {
                            tail[i] = text[tokenIndex];
                            ++i;
                            ++tokenIndex;
                        }
                    }
                }
                if (result >= len) continue;
                token = this.m_parser.decodeNext();
            }
            return result;
        }
        catch (RecognitionException rce) {
            IOException ioex = new IOException("Unexpected parser problem.");
            ioex.initCause(rce);
            throw ioex;
        }
        catch (TokenStreamException tse) {
            IOException ioex = new IOException("Unexpected lexer problem.");
            ioex.initCause(tse);
            throw ioex;
        }
    }
}

