/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.unicode.encoder.latex;

import antlr.ANTLRException;
import antlr.Token;
import info.monitorenter.unicode.encoder.latex.LatexEncoder;
import info.monitorenter.unicode.encoder.latex.LatexEncoderLexer;
import java.io.IOException;
import java.io.Reader;

public class LatexEncoderReader
extends Reader {
    private Reader m_decorated;
    private char[] m_lastTokenRemainder;
    private LatexEncoder m_parser;

    public LatexEncoderReader(Reader decorate) {
        this.m_decorated = decorate;
        LatexEncoderLexer lexer = new LatexEncoderLexer(decorate);
        this.m_parser = new LatexEncoder(lexer);
    }

    public void close() throws IOException {
        this.m_parser = null;
        this.m_decorated.close();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int result = 0;
        int targetIndex = off;
        if (this.m_lastTokenRemainder != null) {
            while (result < len && result < this.m_lastTokenRemainder.length) {
                cbuf[targetIndex] = this.m_lastTokenRemainder[result];
                ++result;
                ++targetIndex;
            }
        }
        try {
            Token token = this.m_parser.encodeNext();
            while (result < len && token.getType() != 1) {
                if (token.getType() == 1) {
                    this.m_lastTokenRemainder = new char[0];
                } else {
                    char[] text = token.getText().toCharArray();
                    int tokenIndex = 0;
                    while (tokenIndex < text.length && result < len) {
                        cbuf[targetIndex] = text[tokenIndex];
                        ++tokenIndex;
                        ++result;
                        ++targetIndex;
                    }
                    if (result == len && text.length > tokenIndex) {
                        char[] tail = new char[text.length - tokenIndex];
                        int i = 0;
                        while (i < tail.length) {
                            tail[i] = text[tokenIndex];
                            ++i;
                            ++tokenIndex;
                        }
                    }
                }
                if (result >= len) continue;
                token = this.m_parser.encodeNext();
            }
            return result;
        }
        catch (ANTLRException tse) {
            IOException ioex = new IOException("Unexpected lexer problem.");
            ioex.initCause(tse);
            throw ioex;
        }
    }
}

