package eu.isas.peptideshaker.gui;

import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import java.util.ArrayList;
import java.util.stream.Collectors;

/**
 * A dialog for mapping unknown modifications to the list of supported
 * modifications.
 *
 * @author Marc Vaudel
 * @author Harald Barsnes
 */
public class ModificationDialog extends javax.swing.JDialog {

    /**
     * The known modifications.
     */
    private ArrayList<String> modifications;
    /**
     * Boolean indicating whether the user pushed the cancel button.
     */
    private boolean cancel = false;

    /**
     * Creates a new ModificationDialog dialog.
     *
     * @param parent the parent frame
     * @param modal if the dialog is modal or not
     * @param unknownPTM the unknown modification
     */
    public ModificationDialog(java.awt.Frame parent, boolean modal, Modification unknownPTM) {
        super(parent, modal);
        loadModifications();
        initComponents();

        // make sure that the scroll panes are see-through
        modificationsJScrollPane.getViewport().setOpaque(false);

        textArea.setText("The modification " + unknownPTM.getName() + " (" + unknownPTM.getRoundedMass()
                + " Da) could not be identified, please select one from the following list to ensure search engine compatibility:");
        modificationList.setListData(modifications.toArray());
        this.setLocationRelativeTo(parent);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        backgroundPanel = new javax.swing.JPanel();
        modificationsJScrollPane = new javax.swing.JScrollPane();
        modificationList = new javax.swing.JList();
        cancelJButton = new javax.swing.JButton();
        okJButton = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        textArea = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Modification Mapping");
        setResizable(false);

        backgroundPanel.setBackground(new java.awt.Color(230, 230, 230));
        backgroundPanel.setToolTipText("");

        modificationList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        modificationList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        modificationsJScrollPane.setViewportView(modificationList);

        cancelJButton.setText("Cancel");
        cancelJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelJButtonActionPerformed(evt);
            }
        });

        okJButton.setText("OK");
        okJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okJButtonActionPerformed(evt);
            }
        });

        textArea.setBackground(new java.awt.Color(254, 254, 254));
        textArea.setColumns(20);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setRows(2);
        textArea.setWrapStyleWord(true);
        jScrollPane2.setViewportView(textArea);

        javax.swing.GroupLayout backgroundPanelLayout = new javax.swing.GroupLayout(backgroundPanel);
        backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(backgroundPanelLayout.createSequentialGroup()
                        .addComponent(okJButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cancelJButton))
                    .addComponent(modificationsJScrollPane, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 496, Short.MAX_VALUE)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 496, Short.MAX_VALUE))
                .addContainerGap())
        );

        backgroundPanelLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {cancelJButton, okJButton});

        backgroundPanelLayout.setVerticalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(modificationsJScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 316, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cancelJButton)
                    .addComponent(okJButton))
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Closes the dialog.
     *
     * @param evt
     */
    private void okJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okJButtonActionPerformed
        this.dispose();
    }//GEN-LAST:event_okJButtonActionPerformed

    /**
     * Closes the dialog.
     *
     * @param evt
     */
    private void cancelJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelJButtonActionPerformed
        cancel = true;
        this.dispose();
    }//GEN-LAST:event_cancelJButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel backgroundPanel;
    private javax.swing.JButton cancelJButton;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JList modificationList;
    private javax.swing.JScrollPane modificationsJScrollPane;
    private javax.swing.JButton okJButton;
    private javax.swing.JTextArea textArea;
    // End of variables declaration//GEN-END:variables

    /**
     * Loads the list of supported modifications.
     */
    private void loadModifications() {
        
        modifications = ModificationFactory.getInstance().getModifications().stream()
                .sorted()
                .collect(Collectors.toCollection(ArrayList::new));
        
    }

    /**
     * Returns the selected modification.
     *
     * @return the selected modification
     */
    public String getSelectedModification() {
        return (String) modificationList.getSelectedValue();
    }

    /**
     * Cancels the selection.
     *
     * @return if the dialog is canceled
     */
    public boolean isCanceled() {
        return cancel;
    }
}
